/*
 * gadTicker.cpp
 *
 *  Created on: 2012/03/22
 *      Author: tanaka
 */
#include "../../ssg/include/ssg.h"
#include "gadTicker.h"
#include <stdlib.h>
#include <malloc.h>

Ticker::Ticker()
{
	text		= NULL;
	speed		= 1;
	font		= NULL;
	bmp			= NULL;
	textWidth	= 0;
	offset		= 0;
	wait		= 0;
}

Ticker::~Ticker()
{
	if( bmp ) delete bmp;
	if( this->text ) free((void*)this->text);
}

void Ticker::onDraw(ssg::Painter *p)
{
	if( bmp == NULL ) {
		bmp = ssg::Bitmap::create(width, height, p->getBitmap()->getPixformat());
	}
	ssg::Painter *pp = new ssg::Painter();
	pp->setBitmap(bmp);
	pp->clear();
	pp->setColor(0xff);
	ssg::Point pt;
	pt.x = -offset;
	pt.y = 0;
	pp->textA(font, &pt, text);
	pt.x	= x;
	pt.y	= y;
	p->image(bmp, &pt);
	delete pp;
}

void Ticker::onEvent(EventCode ec, int data)
{
	if( ec == EC_TIMER ) {
		if( textWidth > width ) {
			int cwait;
			if( offset == 0 )
				cwait 	= speed * 10;
			else
				cwait	= speed;

			if( wait == cwait) {
				wait = 0;
				offset += 2;
				if( offset >= textWidth - width + 10) {
					offset	= 0;
				}
				screen->invalidate();
			} else {
				wait++;
			}
		}
	}
}

bool Ticker::setTicker(const char *text, int speed, ssg::Font *font)
{
	this->speed	= speed;
	this->wait	= 0;
	if( this->text ) free((void*)this->text);
	this->text = strdup(text);
	this->font	= font;
	if(this->screen) this->screen->invalidate();

	ssg::Painter *p = new ssg::Painter();
	ssg::Point size;
	p->textArea(size, font, text);
	textWidth = size.x;
	delete p;
	return true;
}
