/*
 * gadget.h
 *
 *  Created on: 2012/04/05
 *      Author: tanaka
 */

#ifndef GADGET_H_
#define GADGET_H_

#include "controller.h"

namespace ssg {
	class Painter;
};
class Screen;
class BZMPD;

class Gadget {
public:
	Gadget();
	virtual ~Gadget();
	virtual void setPosition(int x, int y, int width, int height);
	virtual void getPosition(int &x, int &y, int &width, int &height);
	virtual void setFrameStyle(int style);

	virtual void onClock() {}
	virtual void onDraw(ssg::Painter *p) {};
	virtual void onEvent(EventCode ec, int data) {}

	virtual void erase(ssg::Painter *p);
	void	drawFrame(ssg::Painter *p);
	Screen *getParent() { return screen; }
	void setParent(Screen *scr);

protected:
	int	x;
	int y;
	int width;
	int height;
	int frame;
	Screen *screen;
	BZMPD *	bzmpdPtr;
};

#endif /* GADGET_H_ */
