/*
 * lock.h
 *
 *  Created on: 2012/03/05
 *      Author: tanaka
 */

#ifndef LOCK_H_
#define LOCK_H_

#include <pthread.h>

class ReadLock;
class WriteLock;

class LockObject {
public:
	LockObject();
	~LockObject();
	void readLock();
	void writeLock();
	void unlock();
protected:
	// non copy
	LockObject(const LockObject &);
	LockObject &operator=(const LockObject &);

	pthread_rwlock_t rwlock;
};

class LockBase {
public:
	LockBase(LockObject &lc) : lock(lc) {}
	virtual ~LockBase() { lock.unlock(); }

private:
	// non copy
	LockBase(const LockBase &);
	LockBase &operator=(const LockBase &);

protected:
	LockObject &lock;
};

class ReadLock : public LockBase {
public:
	ReadLock(LockObject &lc) : LockBase(lc) {
		lc.readLock();
	}
	virtual ~ReadLock() {}
};
class WriteLock : public LockBase {
public:
	WriteLock(LockObject &lc) : LockBase(lc) {
		lc.writeLock();
	}
	virtual ~WriteLock() {}
};


#endif /* LOCK_H_ */
