/*
 * port.cpp
 *
 *  Created on: 2012/03/12
 *      Author: tanaka
 */

#include <syslog.h>
#include "port.h"
#include "device.h"
#include "bzmpd.h"

Port::Port(BZMPD *bzmpd)
{
	bzmpdPtr		= bzmpd;
	receiveDevice 	= NULL;
}
Port::~Port()
{
}

bool Port::setReceiveDevice(Device *dev)
{
	receiveDevice	= dev;
	return true;
}

bool Port::process()
{
	if( receiveDevice == NULL ) {
		char dummy[256];
		size_t	rs;
		recvData(256, dummy, rs);
		bzmpdPtr->log(LOG_ERR, "port %s receiver device not set", getPortName());
		return true;
	}
	return receiveDevice->process(this);
}

bool Port::connect()
{
	if( receiveDevice == NULL ) {
		bzmpdPtr->log(LOG_ERR, "port %s connector not set", getPortName());
		return false;
	}
	return receiveDevice->connect(this);
}

bool Port::sendPacket(size_t size, const char *data)
{
	unsigned char ps = size;
	if( !sendData(1, "S") ||
		!sendData(1, (char*)&ps) ||
		!sendData(size, data) ||
		!sendData(1, "E") ) {
		return false;
	}
	return true;
}

bool Port::recvPacket(size_t size, char *data, size_t &readed)
{
	size_t rs;
	char header[1];
	if( !recvData(1, header, rs) ) {
		bzmpdPtr->log(LOG_ERR, "Port '%s' packet header receive error.", getPortName());
		return false;
	}
	if( header[0] != 'S' ) {
		bzmpdPtr->log(LOG_ERR, "Port '%s' packet frame header is not found.", getPortName());
		return false;
	}
	if( !recvData(1, header, rs) ) {
		bzmpdPtr->log(LOG_ERR, "Port '%s' packet size receive error.", getPortName());
		return false;
	}
	if( header[0] != 0 ) {
		if( (size_t)(header[0]) > size ) {
			bzmpdPtr->log(LOG_ERR, "Port '%s' packet buffer size not enough.", getPortName());
			return false;
		}
	}
	size_t len = header[0];
	if( !recvData(len, data, rs) ) {
		bzmpdPtr->log(LOG_ERR, "Port '%s' packet body receive error.", getPortName());
		return false;
	}
	if( !recvData(1, header, rs) ) return false;
	if( rs != 1 ) {
		bzmpdPtr->log(LOG_ERR, "Port '%s' packet terminator receive error.", getPortName());
		return false;
	}
	if( header[0] != 'E' ) {
		bzmpdPtr->log(LOG_ERR, "Port '%s' packet terminator is not found.", getPortName());
		return false;
	}
	readed = len;
	return true;
}

