/*
 * port.h
 *
 *  Created on: 2012/03/11
 *      Author: tanaka
 */

#ifndef PORT_H_
#define PORT_H_

#include <stdlib.h>
#include <stdio.h>

class Device;
class BZMPD;

class Port {
public:
	Port(BZMPD *bzmpd);
	virtual ~Port();
	virtual const char *getPortName() = 0;
	virtual bool	open(const char *conf) = 0;
	virtual void	close() = 0;
	virtual bool	isConnect() = 0;
	virtual bool	isDataEnd() = 0;
	virtual int		getDesciptor() = 0;
	virtual bool	setReceiveDevice(Device *dev);
	virtual bool	process();
	virtual bool	connect();
	virtual bool	sendPacket(size_t size, const char *data);
	virtual bool	recvPacket(size_t size, char *data, size_t &readed);
	virtual bool	sendData(size_t size, const char *data) = 0;
	virtual bool	recvData(size_t size, char *data, size_t &readed) = 0;

protected:
	BZMPD *	bzmpdPtr;
	Device *receiveDevice;
};


#endif /* PORT_H_ */
