/*
 * port232c.h
 *
 *  Created on: 2012/03/02
 *      Author: tanaka
 */

#ifndef PORT232C_H_
#define PORT232C_H_

#include <termios.h>
#include "port.h"
class BZMPD;

class Port232c : public Port
{
public:
	Port232c(BZMPD *bzmpd);
	virtual ~Port232c();

	virtual const char *getPortName() { return "Port232c"; }
	virtual bool	open(const char *conf);
	virtual void	close();
	virtual bool	isConnect();
	virtual bool	isDataEnd();
	virtual int		getDesciptor();
	virtual bool	sendData(size_t size, const char *data);
	virtual bool	recvData(size_t size, char *data, size_t &readed);

protected:
	int		fd;
	struct termios tioSave;
	char	chunk[256];
	size_t	chunkRead;
	size_t	chunkSize;
	bool	endFile;
};

#endif /* PORT232C_H_ */
