/*
 * portBluetooth.h
 *
 *  Created on: 2012/03/02
 *      Author: tanaka
 */

#ifndef PORTBLUETOOTH_H_
#define PORTBLUETOOTH_H_

#include "port.h"
class BZMPD;

class PortBluetooth : public Port
{
public:
	PortBluetooth(BZMPD *bzmpd);
	~PortBluetooth();
	virtual const char *getName() { return "Bluetooth"; }

	virtual const char *getPortName() { return "PortBluetooth"; }
	virtual bool	open(const char *conf);
	virtual void	close();
	virtual bool	isConnect();
	virtual bool	isDataEnd();
	virtual int		getDesciptor();
	virtual bool	sendData(size_t size, const char *data);
	virtual bool	recvData(size_t size, char *data, size_t &readed);

protected:

};

#endif /* PORTBLUETOOTH_H_ */
