/*
 * portServerSock.cpp
 *
 *  Created on: 2012/03/02
 *      Author: tanaka
 */
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <errno.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "portServerSock.h"
#include "portSock.h"
#include "lock.h"
#include "bzmpd.h"
#include "controller.h"

PortServerSock::PortServerSock(BZMPD *bzmpd) : Port(bzmpd)
{
}

PortServerSock::~PortServerSock()
{
}

bool PortServerSock::open(const char *conf)
{
	const char *p = conf;
	int port	= 0;
	while( '0' <= *p && *p <= '9' ) {
		port = port * 10 + (*p-'0');
		p++;
	}

	struct sockaddr_in srcAddr;
	memset(&srcAddr, 0, sizeof(srcAddr));
	srcAddr.sin_port = htons(port);
	srcAddr.sin_family = AF_INET;
	srcAddr.sin_addr.s_addr = htonl(INADDR_ANY);

	int s = socket(AF_INET, SOCK_STREAM, 0);
	if( s == -1 ) {
		bzmpdPtr->log(LOG_ERR, "tcp socket can't open");
		return false;
	}
	bool optval = 1/*1*/;
	int res = ::setsockopt( s, SOL_SOCKET, SO_REUSEADDR, (char*)&optval, sizeof(bool) );

	if( bind(s, (struct sockaddr *) &srcAddr, sizeof(srcAddr)) == -1 ) {
		bzmpdPtr->log(LOG_ERR, "tcp socket can't bind");
		return false;
	}

	if( listen(s, 1) == -1 ) {
		bzmpdPtr->log(LOG_ERR, "tcp socket can't listen");
		return false;
	}
	sock = s;
	return true;
}

void PortServerSock::close()
{
	::close(sock);
}

bool PortServerSock::isConnect()
{
	return sock != 0;
}

bool PortServerSock::isDataEnd()
{
	return false;
}

int PortServerSock::getDesciptor()
{
	return sock;
}

bool PortServerSock::process()
{
	struct sockaddr_in clientAddr;
	memset(&clientAddr, 0, sizeof(clientAddr));
	socklen_t clientAddrLen=sizeof(clientAddr);

	int c = accept(sock, (struct sockaddr *)&clientAddr, &clientAddrLen);
	PortSock *conn = new PortSock(bzmpdPtr);
	if( conn == NULL ) {
		::close(c);
		return false;
	}
	conn->bindSocket(c, &clientAddr);
	if( receiveDevice == NULL ) {
		bzmpdPtr->log(LOG_ERR, "port receiver not presented");
		delete conn;
		return false;
	}
	if( !receiveDevice->connect(conn) ) {
		delete conn;
		return false;
	}
	return bzmpdPtr->getController()->addClientConnection(conn);
}


