/*
 * portSock.cpp
 *
 *  Created on: 2012/03/06
 *      Author: tanaka
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <cstring>
#include <errno.h>
#include <malloc.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "portSock.h"
#include "bzmpd.h"

PortSock::PortSock(BZMPD *bzmpd) : Port(bzmpd)
{
	this->name	= name;
	sock		= 0;
	endSock		= false;
	chunkRead	= 0;
	chunkSize	= 0;
}

PortSock::~PortSock()
{
	if( isConnect()) close();
}

bool PortSock::open(const char *conf)
{
	char ipaddr[256];
	const char *p = conf;
	while( *p && *p != ':') p++;
	if( *p == ':' ) {
		char hn[256];
		char *p0 = hn;
		p = conf;
		while(*p != ':') {
			*p0++ = *p++;
		}
		*p0 = 0;
		p++;
		struct hostent *he = gethostbyname(hn);
		if( he == NULL ) {
			bzmpdPtr->log(LOG_ERR, "PortSock host '%s' is not found", hn);
			return false;
		}
		sprintf(ipaddr, "%d.%d.%d.%d",
			(unsigned char)*((he->h_addr_list[0])) ,
			(unsigned char)*((he->h_addr_list[0]) + 1) ,
			(unsigned char)*((he->h_addr_list[0]) + 2) ,
			(unsigned char)*((he->h_addr_list[0]) + 3));
	} else {
		p = conf;
		strcpy(ipaddr, "127.0.0.1");
	}
	int port=0;
	while( '0' <= *p && *p <= '9' ) {
		port = port * 10 + (*p-'0');
		p++;
	}
	in_addr_t addr;
	addr = inet_addr(ipaddr);

	struct sockaddr_in mpd_sa;
	memset(&mpd_sa, 0, sizeof(struct sockaddr_in));
	mpd_sa.sin_family	= AF_INET;
	mpd_sa.sin_addr.s_addr	= addr;
	mpd_sa.sin_port 	= htons(port);
	int s	= socket(AF_INET, SOCK_STREAM, 0);
	if( s < 0 ) {
		bzmpdPtr->log(LOG_ERR, "PortSock socket can't create. conf=%s addr=%s port=%d", conf, ipaddr, port);
		return false;
	}
	if( ::connect(s, (struct sockaddr *)&mpd_sa, sizeof(struct sockaddr_in)) < 0) {
		::close(s);
		bzmpdPtr->log(LOG_ERR, "PortSock connect error. conf=%s addr=%s port=%d", conf, ipaddr, port);
		return false;
	}
	int sw = 1;
	ioctl(s, FIONBIO, &sw);
	sock = s;
	bzmpdPtr->log(LOG_INFO, "PortSock connected on conf=%s addr=%s port=%d", conf, ipaddr, port);
	return true;
}

bool PortSock::bindSocket(int sock, struct sockaddr_in *clientAddr)
{
	this->sock	= sock;
	memcpy(&addr, clientAddr, sizeof(struct sockaddr_in));
	return true;
}

void PortSock::close()
{
	if( sock ) {
		::close(sock);
		sock	= 0;
	}
}

bool PortSock::isConnect()
{
	return (sock && !endSock);
}

bool PortSock::isDataEnd()
{
	return endSock;
}

int PortSock::getDesciptor()
{
	return sock;
}

bool PortSock::sendData(size_t size, const char *data)
{
	chunkRead	= 0;
	chunkSize	= 0;
	if( sock == 0 ) {
		bzmpdPtr->log(LOG_ERR, "PortSock: can't send data. port is not open.");
		return false;
	}
	size_t sendLen = ::send(sock, data, size, 0);
	if( sendLen < 0 || sendLen != size ) {
		bzmpdPtr->log(LOG_ERR, "PortSock: send data error.");
		return false;
	}
	return true;
}

bool PortSock::recvData(size_t size, char *data, size_t &readed)
{
	readed = 0;
	char *bp = data;
	while(1) {
		if( chunkSize ) {
			char *p = &chunk[chunkRead];
			while( chunkRead < chunkSize && size > 0 ) {
				if( *p == '\r' || *p == '\n' ) {
					*bp = 0;
					if( *p == '\r' ) { p++; chunkRead++; }
					if( *p == '\n' ) { p++; chunkRead++; }
					readed = bp - data;
					return true;
				}
				*bp++ = *p++;
				size--;
				chunkRead++;
			}
			if( size == 0 ) {
				readed = bp - data;
				return true;
			}
		}

		chunkRead	= 0;
		chunkSize	= 0;
		while(chunkSize == 0) {
			size_t recvs = recv(sock, chunk, sizeof(chunk), 0);
			if(recvs == 0) {
				endSock	= true;
				return false;
			}
			if( (int)recvs == -1) {
				if( errno == EAGAIN ) {
					continue;
				} else {
					bzmpdPtr->log(LOG_ERR, "PortSock recv error");
					return false;
				}
			}
			chunkSize = recvs;
		}
	}
	return false;
}

