/*
 * portSock.h
 *
 *  Created on: 2012/03/05
 *      Author: tanaka
 */

#ifndef PORTSOCK_H_
#define PORTSOCK_H_

#include <sys/socket.h>
#include <netinet/in.h>
#include "port.h"
class BZMPD;


class PortSock : public Port
{
public:
	PortSock(BZMPD *bzmpd);
	~PortSock();

	virtual const char *getPortName() { return "TCP"; }
	virtual bool	open(const char *conf);
	virtual void	close();
	virtual bool	isConnect();
	virtual bool	isDataEnd();
	virtual int		getDesciptor();
	virtual bool	sendData(size_t size, const char *data);
	virtual bool	recvData(size_t size, char *data, size_t &readed);

	bool	bindSocket(int sock, struct sockaddr_in *clientAddr);
protected:
	const char *name;
	int		sock;
	bool	endSock;
	struct sockaddr_in	addr;
	char	chunk[256];
	size_t	chunkRead;
	size_t	chunkSize;
};

#endif /* PORTSOCK_H_ */
