/*
 * port232c.h
 *
 *  Created on: 2012/03/02
 *      Author: tanaka
 */

#ifndef PORTUSB_H_
#define PORTUSB_H_

#include <usb.h>
#include "port.h"
#include "lock.h"

class BZMPD;

class PortUSB : public Port
{
public:
	PortUSB(BZMPD *bzmpd);
	virtual ~PortUSB();

	virtual const char *getPortName() { return "USB"; }
	virtual bool	open(const char *conf);
	virtual void	close();
	virtual bool	isConnect();
	virtual bool	isDataEnd();
	virtual int		getDesciptor();
	virtual bool	sendPacket(size_t size, const char *data);
	virtual bool	recvPacket(size_t size, char *data, size_t &readed);
	virtual bool	sendData(size_t size, const char *data);
	virtual bool	recvData(size_t size, char *data, size_t &readed);

protected:
	struct usb_device *findUSBDevice(int vid, int pid);
	static void *threadEntry(void *);
	void	*mainLoop();

	int		pipe_fd[2];
	usb_dev_handle *uh;
	int		u_in;
	int		u_out;

	bool		doStop;
	pthread_t 	threadHandle;
	pthread_t 	*threadHandlePtr;
	LockObject	lockObject;

	char	chunk[256];
	size_t	chunkRead;
	size_t	chunkSize;
	bool	endFile;
};

#endif /* PORTUSB_H_ */
