/*
 * scrAlbum.cpp
 *
 *  Created on: 2012/03/26
 *      Author: tanaka
 */
#include "../../ssg/include/ssg.h"
#include "screen.h"
#include "scrAlbum.h"

ScrAlbum::ScrAlbum(Controller *cp) : Screen(cp, SC_ALBUM)
{
	ld.nItems	= 0;
	ld.pItems	= NULL;
	mpAlbum		= NULL;
	lb.setParent(this);
}

ScrAlbum::~ScrAlbum()
{
}

void ScrAlbum::onCreate()
{
	if( ld.pItems ) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;

	mpAlbum	= controller->cmdListAlbum();
	if( mpAlbum->count != 0 ) {
		ld.pItems	= (LISTITEM*)malloc(sizeof(LISTITEM)*mpAlbum->count);
		ld.nItems	= mpAlbum->count;
		for( int i = 0; i < mpAlbum->count; i++) {
			ld.pItems[i].id		= i;
			ld.pItems[i].text	= mpAlbum->metadatas[i].value;
		}
	}
	ssg::Font *font = controller->getSmallFont();
	int fs = font->getAscent()+font->getDescent();
	lb.setPosition(0, fs, 256, 64-fs);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	Screen::onCreate();
}

void ScrAlbum::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_ENTER ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpAlbum->count ) {
			controller->cmdSetAlbum(n);
			goScreen(SC_MEDIATRACK);
		}
		return;
	}
	if( ec == EC_KEY && data == KC_PLAY ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpAlbum->count ) {
			controller->cmdSetAlbum(n);
			controller->cmdPlayAlbum();
			goScreen(SC_MEDIATRACK);
		}
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrAlbum::onDraw(ssg::Painter *pp)
{
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	char t[1024];
	const MPD_METADATA_LIST *artistList = controller->cmdListArtist();
	sprintf(t, "Album - %s", artistList->metadatas[controller->cmdGetArtist()].value);
	pp->textA(font, &pt, t);
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	Screen::onDraw(pp);
}

void ScrAlbum::onDestory()
{
	if(ld.pItems) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;
	removeGadget(&lb);
	Screen::onDestory();
}
