/*
 * scrArtist.cpp
 *
 *  Created on: 2012/03/26
 *      Author: tanaka
 */
#include <syslog.h>

#include "screen.h"
#include "scrArtist.h"
#include "../../ssg/include/ssg.h"

ScrArtist::ScrArtist(Controller *cp) : Screen(cp, SC_ARTIST)
{
	ld.nItems	= 0;
	ld.pItems	= NULL;
	mpArtist	= NULL;
	lb.setParent(this);
}

ScrArtist::~ScrArtist()
{
}

void ScrArtist::onCreate()
{
	if( bzmpdPtr == NULL )  {
		printf("err ScrArtist::onCreate\n");
	}
	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat");
	if( ld.pItems ) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;

	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat1");
	mpArtist	= controller->cmdListArtist();
	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat2 mpArtist=%x", mpArtist);
	if( mpArtist->count != 0 ) {
		bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat3");
		ld.pItems	= (LISTITEM*)malloc(sizeof(LISTITEM)*mpArtist->count);
		ld.nItems	= mpArtist->count;
		for( int i = 0; i < mpArtist->count; i++) {
			ld.pItems[i].id		= i;
			ld.pItems[i].text	= mpArtist->metadatas[i].value;
		}
	}
	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat4");
	ssg::Font *font = controller->getSmallFont();
	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat5");
	int fs = font->getAscent()+font->getDescent();
	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat6");
	lb.setPosition(0, fs, 256, 64-fs);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	bzmpdPtr->log(LOG_INFO, "ScrArtist::onCreat7");
	Screen::onCreate();
}

void ScrArtist::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_ENTER ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpArtist->count ) {
			controller->cmdSetArtist(n);
			goScreen(SC_ALBUM);
			return;
		}
		bzmpdPtr->log(LOG_INFO, "ScrArtist::onEvent select error");
		return;
	}
	if( ec == EC_KEY && data == KC_PLAY ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpArtist->count ) {
			controller->cmdSetArtist(n);
			controller->cmdPlayArtist();
			goScreen(SC_MEDIATRACK);
		}
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrArtist::onDraw(ssg::Painter *pp)
{
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	pp->textA(font, &pt, "Artist");
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	Screen::onDraw(pp);
}

void ScrArtist::onDestory()
{
	if(ld.pItems) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;
	removeGadget(&lb);
	Screen::onDestory();
}
