/*
 * scrFmFreq.cpp
 *
 *  Created on: 2012/03/23
 *      Author: tanaka
 */
#include "screen.h"
#include "scrFmFreq.h"
#include "../../ssg/include/ssg.h"

ScrFmFrequency::ScrFmFrequency(Controller *cp) : Screen(cp, SC_FMFREQ)
{
}

ScrFmFrequency::~ScrFmFrequency()
{
}

void ScrFmFrequency::onCreate()
{
	scanning	= false;
	region	= controller->getFmRegion();
	controller->cmdGetFmStatus(status);
	stationName[0] = 0;
	if( status.tunneLevel != 0 ) {
		STATION *st = controller->findFmStation(status.freq);
		if( st ) {
			strcpy(stationName, st->stationName);
		}
	}
	Screen::onCreate();
}

void ScrFmFrequency::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY ) {
		if( scanning ) {
			scanning = false;
			invalidate();
			return;
		}
	}
	if( ec == EC_ROTATE ) {
		if( scanning ) {
			scanning = false;
			invalidate();
			return;
		}
		int freq = status.freq;
		scanning = true;
		if( !controller->cmdScanFmStatus(data) ) return;
		while(1) {
			if( !controller->dispatch() ) break;
			if( !scanning ) return;
			if( !controller->cmdGetFmStatus(status)) return;
			if( status.tunneLevel != 0 ) break;
			if( status.limitScan ) {
				if( data < 0 ) {
					if( !controller->cmdSetFmFrequency(910) ) return;
				} else {
					if( !controller->cmdSetFmFrequency(760) ) return;
				}
				if( !controller->cmdScanFmStatus(data) ) return;
			}
			if( freq != status.freq ) invalidate();
			freq = status.freq;
		}
		invalidate();
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrFmFrequency::onDraw(ssg::Painter *pp)
{
	pp->clear();

	ssg::Font *sfont = controller->getSmallFont();
	ssg::Font *mfont = controller->getMediumFont();
	ssg::Font *lfont = controller->getLargeFont();

	char freq[16];
	sprintf(freq, "%2.2d.1.1dMHz", status.freq/10, status.freq%10);
	ssg::Point fs;
	pp->textArea(fs, lfont, freq);
	ssg::Point pt;
	pt.x = 0;
	pt.y = mfont->getAscent();
	pp->textA(mfont, &pt, "FM Frequency");

	char text[256];
	sprintf(text, "%s Level %d ", status.tunneLevel > 0 ? (status.stereo ? "STEREO" : "MONO") : "NO SIGNAL", status.tunneLevel);
	pp->textArea(fs, sfont, freq);
	pt.x = 256 - fs.x - mfont->getDescent();
	pp->textA(mfont, &pt, text);

	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = mfont->getAscent()+mfont->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);

	pt.x = (256-fs.x)/2;
	pt.y = (64 / 2) - fs.y + lfont->getAscent();
	pp->textA(lfont, &pt, freq);

	if( status.tunneLevel > 0 ) {
		STATION *st = controller->findFmStation(status.freq);
		if( st ) {
			char stname[1024];
			sprintf(stname, "%s $s", st->callName, st->stationName);
			pp->textArea(fs, mfont, stname);
			pt.x = 256 - fs.x - mfont->getDescent();
			pt.y = 64 - fs.y - mfont->getDescent() * 2;
			pp->textA(mfont, &pt, text);
		}
	}
	Screen::onDraw(pp);
}

void ScrFmFrequency::onDestory()
{
	Screen::onDestory();
}




