/*
 * scrFmStation.cpp
 *
 *  Created on: 2012/03/16
 *      Author: tanaka
 */
#include "screen.h"
#include "scrFmStation.h"
#include "../../ssg/include/ssg.h"

static LISTDATA ld = {
		0,
		NULL,
};

ScrFmStation::ScrFmStation(Controller *cp) : Screen(cp, SC_FMSTATION)
{
	lb.setParent(this);
}

ScrFmStation::~ScrFmStation()
{
}

void ScrFmStation::onCreate()
{
	ssg::Font *font = controller->getSmallFont();
	int fs = font->getAscent()+font->getDescent();
	lb.setPosition(0, fs, 256, 64-fs);
	addGadget(&lb);

	strcpy(regionName, "-");
	regionCode = 0;
	REGIONLIST *rgl = controller->getFmRegionList();
	if( rgl ) {
		regionCode = controller->getFmRegion();
		for( int i = 0; i < rgl->nRegions; i++ ) {
			if( rgl->pRegions[i].id == regionCode ) {
				strcpy( regionName, rgl->pRegions[i].regionName );
				break;
			}
		}
	}
	stations	= controller->getFmStationList();
	if( stations ) {
		ld.nItems	= stations->nStations;
		ld.pItems	= (LISTITEM*)malloc(sizeof(LISTITEM)*ld.nItems);
		for( int i = 0; i < ld.nItems; i++ ) {
			ld.pItems[i].id	= i;
			ld.pItems[i].text	= stations->pStations[i].stationName;
		}
	}
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	Screen::onCreate();
}

void ScrFmStation::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_ENTER ) {
		int n = lb.getSelectItem();
		int nFreq = stations->pStations[n].nFreq;
		int i;
		for( i = 0; i < nFreq; i++ ) {
			int freq = stations->pStations[n].pFreq[i].freq;
			if( controller->cmdSetFmFrequency(freq) ) {
				TUNESTATUS st;
				if( controller->cmdGetFmStatus(st) ) {
					if( st.tunneLevel != 0 ) {
						goScreen(SC_FMPLAY);
						return;
					}
				}
			}
		}
		char tt[512];
		sprintf( tt, "FM %s", stations->pStations[n].stationName );
		messageBox(tt, "Signal Not Found", MBF_OK, 2);
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrFmStation::onDraw(ssg::Painter *pp)
{
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	pp->textA(font, &pt, "FM Stations");
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	Screen::onDraw(pp);
}

void ScrFmStation::onDestory()
{
	removeGadget(&lb);
	ld.nItems = 0;
	if( ld.pItems ) free(ld.pItems);
	Screen::onDestory();
}
