/*
 * scrMediaPlay.cpp
 *
 *  Created on: 2012/03/28
 *      Author: tanaka
 */
#include "screen.h"
#include "scrMediaPlay.h"
#include "../../ssg/include/ssg.h"

ScrMediaPlay::ScrMediaPlay(Controller *cp) : Screen(cp, SC_MEDIAPLAY)
{
}

ScrMediaPlay::~ScrMediaPlay()
{
}

void ScrMediaPlay::onCreate()
{
	Screen::onCreate();
}

void ScrMediaPlay::onEvent(EventCode ec, int data)
{
	if( ec == EC_ROTATE ) {
		if( data < 0 ) {
			controller->cmdPrev();
		} else {
			controller->cmdNext();
		}
		invalidate();
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrMediaPlay::onDraw(ssg::Painter *pp)
{
	pp->clear();

	ssg::Font *sfont = controller->getSmallFont();
	ssg::Font *mfont = controller->getMediumFont();
	ssg::Font *lfont = controller->getLargeFont();

	TUNESTATUS status;
	controller->cmdGetFmStatus(status);

	char freq[16];
	sprintf(freq, "%2.2d.1.1dMHz", status.freq/10, status.freq%10);
	ssg::Point fs;
	pp->textArea(fs, lfont, freq);
	ssg::Point pt;
	pt.x = 0;
	pt.y = mfont->getAscent();
	pp->textA(mfont, &pt, "FM Frequency");

	char text[256];
	sprintf(text, "%s Level %d ", status.tunneLevel > 0 ? (status.stereo ? "STEREO" : "MONO") : "NO SIGNAL", status.tunneLevel);
	pp->textArea(fs, sfont, freq);
	pt.x = 256 - fs.x - mfont->getDescent();
	pp->textA(mfont, &pt, text);

	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = mfont->getAscent()+mfont->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);

	pt.x = (256-fs.x)/2;
	pt.y = (64 / 2) - fs.y + lfont->getAscent();
	pp->textA(lfont, &pt, freq);

	if( status.tunneLevel > 0 ) {
		STATION *st = controller->findFmStation(status.freq);
		if( st ) {
			char stname[1024];
			sprintf(stname, "%s $s", st->callName, st->stationName);
			pp->textArea(fs, mfont, stname);
			pt.x = 256 - fs.x - mfont->getDescent();
			pt.y = 64 - fs.y - mfont->getDescent() * 2;
			pp->textA(mfont, &pt, text);
		}
	}
	Screen::onDraw(pp);
}

void ScrMediaPlay::onDestory()
{
	Screen::onDestory();
}








