/*
 * scrPlaylist.cpp
 *
 *  Created on: 2012/03/30
 *      Author: tanaka
 */
#include "screen.h"
#include "scrPlaylist.h"
#include "../../ssg/include/ssg.h"

ScrPlaylist::ScrPlaylist(Controller *cp) : Screen(cp, SC_ARTIST)
{
	ld.nItems	= 0;
	ld.pItems	= NULL;
	mpPlaylist	= NULL;
	lb.setParent(this);
}

ScrPlaylist::~ScrPlaylist()
{
}

void ScrPlaylist::onCreate()
{
	if( ld.pItems ) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;

	mpPlaylist	= controller->cmdListArtist();
	if( mpPlaylist->count != 0 ) {
		ld.pItems	= (LISTITEM*)malloc(sizeof(LISTITEM)*mpPlaylist->count);
		ld.nItems	= mpPlaylist->count;
		for( int i = 0; i < mpPlaylist->count; i++) {
			ld.pItems[i].id		= i;
			ld.pItems[i].text	= mpPlaylist->metadatas[i].value;
		}
	}
	ssg::Font *font = controller->getSmallFont();
	int fs = font->getAscent()+font->getDescent();
	lb.setPosition(0, fs, 256, 64-fs);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	Screen::onCreate();
}

void ScrPlaylist::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_PLAY ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpPlaylist->count ) {
			controller->cmdStop();
			controller->cmdLoadPlaylist(mpPlaylist->metadatas[n].value);
			controller->cmdPlay();
			goScreen(SC_MEDIAPLAY);
		}
		return;
	}
	if( ec == EC_KEY && data == KC_PLAY ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpPlaylist->count ) {
			controller->cmdSetPlaylist(n);
			goScreen(SC_PLAYLISTTRACK);
		}
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrPlaylist::onDraw(ssg::Painter *pp)
{
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	pp->textA(font, &pt, "Playlist");
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	Screen::onDraw(pp);
}

void ScrPlaylist::onDestory()
{
	if(ld.pItems) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;
	removeGadget(&lb);
	Screen::onDestory();
}




