/*
 * scrPlaylistTrack.cpp
 *
 *  Created on: 2012/03/30
 *      Author: tanaka
 */
#include "screen.h"
#include "scrPlaylistTrack.h"
#include "../../ssg/include/ssg.h"

ScrPlaylistTrack::ScrPlaylistTrack(Controller *cp) : Screen(cp, SC_MEDIATRACK)
{
	ld.nItems	= 0;
	ld.pItems	= NULL;
	mpTrack		= NULL;
	lb.setParent(this);
}

ScrPlaylistTrack::~ScrPlaylistTrack()
{
}

void ScrPlaylistTrack::onCreate()
{
	if( ld.pItems ) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;

	DevMPD *mpd = controller->getMPD();
	int tagTitle = mpd->getTagId("Title");
	int tagTrack = mpd->getTagId("Track");
	int tagTime = mpd->getTagId("Time");
	mpTrack	= controller->cmdListPlaylistTrack();
	if( mpTrack->count != 0 ) {
		ld.pItems	= (LISTITEM*)malloc(sizeof(LISTITEM)*mpTrack->count);
		ld.nItems	= mpTrack->count;
		for( int i = 0; i < mpTrack->count; i++) {
			MPD_METADATA_LIST *pt = mpTrack->metagroup[i];
			int nTitle = mpd->findMetaData(*pt, tagTitle);
			ld.pItems[i].id		= i;
			ld.pItems[i].text	= pt->metadatas[nTitle].value;
		}
	}
	ssg::Font *font = controller->getSmallFont();
	int fs = font->getAscent()+font->getDescent();
	lb.setPosition(0, fs, 256, 64-fs);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	Screen::onCreate();
}

void ScrPlaylistTrack::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY ) {
		if( data == KC_ENTER || data == KC_PLAY ) {
			int n = lb.getSelectItem();
			if( 0 <= n && n < mpTrack->count ) {
				const MPD_METADATA_LIST *ppl = controller->cmdListPlaylist();
				int plid = controller->cmdGetPlaylist();
				controller->cmdStop();
				controller->cmdLoadPlaylist(ppl->metadatas[plid].value);
				controller->cmdPlay();
				goScreen(SC_MEDIAPLAY);
			}
			return;
		}
	}
	Screen::onEvent(ec, data);
}

void ScrPlaylistTrack::onDraw(ssg::Painter *pp)
{
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	char t[1024];
	sprintf(t, "Tracks - %s %s", controller->cmdGetAlbum(), controller->cmdGetArtist());
	pp->textA(font, &pt, t);
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	Screen::onDraw(pp);
}

void ScrPlaylistTrack::onDestory()
{
	if(ld.pItems) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;
	removeGadget(&lb);
	Screen::onDestory();
}
