/*
 * scrSelector.cpp
 *
 *  Created on: 2012/03/16
 *      Author: tanaka
 */

#include "screen.h"
#include "scrSelector.h"
#include "../../ssg/include/ssg.h"

static LISTITEM li[] = {
	{1, "Artist"},
	{2, "Play List"},
	{3, "FM Station"},
	{4, "FM Frequency"},
};

static LISTDATA ld = {
	4,
	li
};

ScrSelector::ScrSelector(Controller *cp) : Screen(cp, SC_SELECTOR)
{
	lb.setParent(this);
}

ScrSelector::~ScrSelector()
{
}

void ScrSelector::onCreate()
{
	if( bzmpdPtr == NULL )  {
		printf("err ScrSelector::onCreate\n");
	}

	bzmpdPtr->log(LOG_INFO, "ScrSelector::onCreat");

	ssg::Font *font = controller->getSmallFont();
	int fs = font->getAscent()+font->getDescent();
	lb.setPosition(0, fs, 256, 64-fs);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	Screen::onCreate();
}

void ScrSelector::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_ENTER ) {
		int n = lb.getSelectItem();
		switch(n) {
		case 1:	goScreen(SC_ARTIST);	break;
		case 2:	goScreen(SC_PLAYLIST);	break;
		case 3:	goScreen(SC_FMSTATION);	break;
		case 4:	goScreen(SC_FMFREQ);	break;
		}
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrSelector::onDraw(ssg::Painter *pp)
{
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	pp->textA(font, &pt, "Source Selector");
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	Screen::onDraw(pp);
}

void ScrSelector::onDestory()
{
	removeGadget(&lb);
	Screen::onDestory();
}



