/*
 * scrTopmenu.cpp
 *
 *  Created on: 2012/03/16
 *      Author: tanaka
 */

#include <syslog.h>
#include "screen.h"
#include "scrTopmenu.h"
#include "../../ssg/include/ssg.h"

static LISTITEM li[] = {
	{1, "Source Select"},
	{2, "Setting"},
};

static LISTDATA ld = {
	2,
	li
};

ScrTopmenu::ScrTopmenu(Controller *cp) : Screen(cp, SC_TOPMENU)
{
	lb.setParent(this);
}

ScrTopmenu::~ScrTopmenu()
{
	removeGadget(&lb);
}

void ScrTopmenu::onCreate()
{
	bzmpdPtr->log(LOG_INFO, "ScrTopmenu::onCreat");

	lb.setPosition(0, 16, 256, 64-16);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	Screen::onCreate();
}

void ScrTopmenu::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_ENTER ) {
		int n = lb.getSelectItem();
		bzmpdPtr->log(LOG_INFO, "ScrTopmenu::onEvent ec=%d d=%d n=%d", ec, data, n);
		switch( n ) {
		case 1:	goScreen(SC_SELECTOR);	break;
		case 2: goScreen(SC_SETTING);	break;
		}
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrTopmenu::onDraw(ssg::Painter *pp)
{
	Screen::onDraw(pp);
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = font->getDescent();
	pt.y = font->getAscent()+font->getDescent();
	//pt.y = 0;
	pp->textA(controller->getSmallFont(), &pt, "Main Menu");
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = 16;
	pt1.x = 255;
	pt1.y = 16;
	pp->line(&pt0, &pt1);
}

void ScrTopmenu::onDestory()
{
	Screen::onDestory();
}
