/*
 * scrTrack.cpp
 *
 *  Created on: 2012/03/26
 *      Author: tanaka
 */
#include "screen.h"
#include "scrTrack.h"
#include "../../ssg/include/ssg.h"

ScrTrack::ScrTrack(Controller *cp) : Screen(cp, SC_MEDIATRACK)
{
	ld.nItems	= 0;
	ld.pItems	= NULL;
	mpTrack		= NULL;
	lb.setParent(this);
}

ScrTrack::~ScrTrack()
{
}

void ScrTrack::onCreate()
{
	bzmpdPtr->log(LOG_INFO, "ScrTrack::onCreat");

	if( ld.pItems ) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;

	DevMPD *mpd = controller->getMPD();
	int tagTitle = mpd->getTagId("Title");
	int tagTrack = mpd->getTagId("Track");
	int tagTime = mpd->getTagId("Time");
	mpTrack	= controller->cmdListTrack();
	if( mpTrack->count != 0 ) {
		ld.pItems	= (LISTITEM*)malloc(sizeof(LISTITEM)*mpTrack->count);
		ld.nItems	= mpTrack->count;
		for( int i = 0; i < mpTrack->count; i++) {
			MPD_METADATA_LIST *pt = mpTrack->metagroup[i];
			int nTitle = mpd->findMetaData(*pt, tagTitle);
			ld.pItems[i].id		= i;
			ld.pItems[i].text	= pt->metadatas[nTitle].value;
		}
	}
	ssg::Font *font = controller->getSmallFont();
	int fs = font->getAscent()+font->getDescent();
	lb.setPosition(0, fs, 256, 64-fs);
	lb.setList(&ld, controller->getMediumFont());
	lb.selectListItem(0);
	addGadget(&lb);
	bzmpdPtr->log(LOG_INFO, "ScrTrack::onCreat2");
	Screen::onCreate();
}

void ScrTrack::onEvent(EventCode ec, int data)
{
	if( ec == EC_KEY && data == KC_ENTER ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpTrack->count ) {
			controller->cmdSetTrack(n);
			controller->cmdPlayTrack();
			goScreen(SC_MEDIAPLAY);
		}
		return;
	}
	if( ec == EC_KEY && data == KC_PLAY ) {
		int n = lb.getSelectItem();
		if( 0 <= n && n < mpTrack->count ) {
			controller->cmdSetTrack(n);
			controller->cmdPlayTrack();
			goScreen(SC_MEDIATRACK);
		}
		return;
	}
	Screen::onEvent(ec, data);
}

void ScrTrack::onDraw(ssg::Painter *pp)
{
	bzmpdPtr->log(LOG_INFO, "ScrTrack::onDraw1" );
	ssg::Font *font = controller->getSmallFont();
	ssg::Point pt;
	pt.x = 0;
	pt.y = font->getAscent();
	const char *artistName = controller->cmdGetArtistName();
	const char *albumName = controller->cmdGetAlbumName();
	char t[4096];
	bzmpdPtr->log(LOG_INFO, "Tracks - %s %s", albumName, artistName);
	sprintf(t, "Tracks - %s %s", albumName, artistName);
	pp->textA(font, &pt, t);
	ssg::Point pt0, pt1;
	pt0.x = 0;
	pt0.y = font->getAscent()+font->getDescent();
	pt1.x = 255;
	pt1.y = pt0.y;
	pp->line(&pt0, &pt1);
	bzmpdPtr->log(LOG_INFO, "ScrTrack::onDraw2" );
	Screen::onDraw(pp);
	bzmpdPtr->log(LOG_INFO, "ScrTrack::onDraw3" );
}

void ScrTrack::onDestory()
{
	if(ld.pItems) {
		free(ld.pItems);
	}
	ld.nItems	= 0;
	ld.pItems	= NULL;
	removeGadget(&lb);
	Screen::onDestory();
}
