/*
 * screen.cpp
 *
 *  Created on: 2012/03/16
 *      Author: tanaka
 */

#include <syslog.h>
#include <time.h>
#include "gadget.h"
#include "screen.h"
#include "gadMessageBox.h"
#include "../../ssg/include/ssg.h"

Screen::Screen(Controller *cp, int gid)
{
	id			= gid;
	bGadgets	= 0;
	nGadgets	= 0;
	pGadgets	= NULL;
	controller	= cp;
	invalid		= true;
	bzmpdPtr	= controller->getBZMPD();
}

Screen::~Screen()
{
	int i;
	if( pGadgets ) free((void*)pGadgets);
}

void Screen::onCreate() {}
void Screen::onActivate()
{
	doPaint();
}

void Screen::onEvent(EventCode ec, int data)
{
	switch( ec ) {
	case EC_KEY:
		bzmpdPtr->log(LOG_INFO, "Screen::onEvent ec=%d d=%d", ec, data);
		if( data == KC_ESC || data == KC_MENU ) {
			// cancel/esc
			gobackScreen();
			return;
		}
		break;
	}
	if( nGadgets ) {
		pGadgets[nGadgets-1]->onEvent(ec, data);
	}
	controller->onEvent(ec, data);
}

void Screen::onDraw(ssg::Painter *p)
{
	int i;
	for( i = 0; i < nGadgets; i++) {
		pGadgets[i]->onDraw(p);
	}
}

void Screen::onInactivate()
{
}

void Screen::onDestory()
{
}

bool Screen::goScreen(int id)
{
	return controller->goScreen(id);
}

bool Screen::goNoHistory(int id)
{
	return controller->goNoHistory(id);
}

bool Screen::gobackScreen()
{
	return controller->gobackScreen();
}

bool Screen::addGadget(Gadget *g)
{
	if( nGadgets+1 >= bGadgets ) {
		int bNew = bGadgets + 4;
		Gadget **pNew = (Gadget**)realloc(pGadgets, sizeof(Gadget*)*bNew);
		if( !pNew ) return false;
		pGadgets	= pNew;
		bGadgets	= bNew;
	}
	pGadgets[nGadgets++] = g;
	invalidate();
	return true;
}

bool Screen::removeGadget(Gadget *g)
{
	int i;
	for( i = 0; i < nGadgets; i++ ) {
		if( pGadgets[i] == g ) {
			break;
		}
	}
	if( i >= nGadgets ) return false;
	for( ; i < nGadgets-1; i++ ) {
		pGadgets[i] = pGadgets[i+1];
	}
	nGadgets--;
	invalidate();
	return true;
}

MessageBoxFlag	Screen::messageBox(const char *title, const char *msg, int flag, int wt)
{
	MessageBox *mb = new MessageBox();
	mb->set(title, msg, (MessageBoxFlag)flag, MBF_OK, wt, controller->getMediumFont());
	addGadget(mb);
	while(1) {
		if( !controller->dispatch() ) break;
		if( mb->getSelect() != 0 ) break;
	}
	MessageBoxFlag rt = mb->getSelect();
	delete mb;
	return rt;
}

void Screen::invalidate()
{
	invalid	= true;
}

void Screen::doPaint()
{
	bzmpdPtr->log(LOG_INFO, "Screen::doPaint 1" );

	ssg::Bitmap *bmp0 = controller->getScreenBitmap();
	ssg::Bitmap *bmp1 = ssg::Bitmap::create(bmp0->getWidth(), bmp0->getHeight(), bmp0->getPixformat());
	ssg::Painter *painter = controller->getPainter();
	painter->setBitmap(bmp1);
	painter->clear();
	bzmpdPtr->log(LOG_INFO, "Screen::doPaint 2" );
	onDraw(painter);
	bzmpdPtr->log(LOG_INFO, "Screen::doPaint 3" );

	unsigned char *pp = (unsigned char*)bmp1->getBitmap();
	for(int n=0; n<16; n++) {
		bzmpdPtr->log(LOG_INFO, "b %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
				pp[0], pp[1], pp[2], pp[3], pp[4], pp[5], pp[6], pp[7]);
		pp += 32;
	}
	bzmpdPtr->log(LOG_INFO, "Screen::doPaint 4" );

	DevFirm *dev = controller->getFirm();
	ssg::Bitmap::SegmentIterator *i0 = bmp0->createSegIterator();
	ssg::Bitmap::SegmentIterator *i1 = bmp1->createSegIterator();
	ssg::INT hs, vs;
	ssg::INT xs, ys;
	hs = bmp0->getHorzSegments();
	vs = bmp0->getVertSegments();
	bzmpdPtr->log(LOG_INFO, "Screen::doPaint 5 hs=%d vs=%d", hs, vs );
	for( ys = 0; ys < vs; ys++ ) {
		i0->setPosition(0,ys);
		i1->setPosition(0,ys);
		for( xs = 0; xs < hs; xs++ ) {
			if( *i0 != *i1 ) {
				ssg::BYTE d[256];
				i1->getSegment(d);
				dev->updateDisplay(ys, xs, (char*)d);
				i0->copySegment(*i1);
			}
			i0->next();
			i1->next();
		}
	}
	bzmpdPtr->log(LOG_INFO, "Screen::doPaint 6" );

	invalid	= false;
}
