/*
 * screen.h
 *
 *  Created on: 2012/03/13
 *      Author: tanaka
 */

#ifndef SCREEN_H_
#define SCREEN_H_

#include "controller.h"

class Screen;
class Gadget;
class BZMPD;

namespace ssg {
	class Bitmap;
	class Font;
	class Painter;
}

#define FONT_HEIGHT	16

/*
 * TOPMENU
 * 		SOURCE
 * 			ARTIST
 * 				ALBUM
 * 					TRACK
 * 			PLAYLIST
 * 				TRACK
 * 			[MEDIAPLAY]
 * 			FM STATION-LIST
 * 			FM PLAY
 * 		SETTING MENU
 * 			MODE
 * 				Open
 * 				Close - Day
 * 				Close - Night
 * 			FM-PRESET
 * 				LOCAL-LIST  TOKYO
 * 							KANAGAWA
 * 			IMPORT
 * 				Import SD card
 */


enum ScreenId {
	SC_TOPMENU = 1,
	SC_SELECTOR,
	SC_ARTIST,
	SC_ALBUM,
	SC_MEDIATRACK,
	SC_PLAYLIST,
	SC_PLAYLISTTRACK,
	SC_MEDIAPLAY,
	SC_FMSTATION,
	SC_FMFREQ,
	SC_FMPLAY,
	SC_SETTING,
	SC_MODE,
	SC_FMREGION,
	SC_IMPORT,
};

enum MessageBoxFlag {
	MBF_NULL = 0,
	MBF_OK = 0x01,
	MBF_CANCEL = 0x02,
	MBF_YES = 0x04,
	MBF_NO = 0x08,
	MBF_ICON_INFO = 0x10,
	MBF_ICON_ERR = 0x20,
	MBF_ICON_QUESTION = 0x40,
	MBF_ICON_CAUTION = 0x80,
};

typedef struct _LISTITEM {
	int	id;
	const char *text;
} LISTITEM;

typedef struct _LISTDATA {
	int			nItems;
	LISTITEM *	pItems;
} LISTDATA;


class Screen
{
public:
	Screen(Controller *cp, int id);
	virtual ~Screen();

	virtual void onCreate();
	virtual void onActivate();
	virtual void onEvent(EventCode ec, int data);
	virtual void onDraw(ssg::Painter *bmp);
	virtual void onInactivate();
	virtual void onDestory();

	BZMPD *	getBZMPD() { return bzmpdPtr; }
	int	getId() { return id; }
	bool goScreen(int id);
	bool goNoHistory(int id);
	bool gobackScreen();
	bool popupScreen(int id, int timeoutSec);

	bool addGadget(Gadget *g);
	bool removeGadget(Gadget *g);
	MessageBoxFlag	messageBox(const char *title, const char *msg, int flag, int wt);
	void invalidate();
	bool needPaint() { return invalid; }
	void doPaint();

protected:
	int		id;
	// key control

	// gadgets
	int			nGadgets;
	int			bGadgets;
	Gadget **	pGadgets;
	bool		invalid;
	BZMPD *		bzmpdPtr;
	Controller *controller;
};

#endif /* SCREEN_H_ */
