;
; PIC16F873A 20MHz
;
		LIST	P=PIC16F873A
		INCLUDE	"P16F873A.INC"
		__CONFIG _HS_OSC & _LVP_OFF & _WDT_OFF & _PWRTE_OFF & _BODEN_OFF
		INCLUDE	"SSD1322.INC"
;
; PORT MAP
;
; PUSH SWITCH
PS_PORT		EQU	PORTA	; GENERIC PUSH SWITCH
PS_BIT0		EQU	0	; IN PUSH SW BIT 0
PS_BIT2		EQU	1	; IN PUSH SW BIT 1
PS_BIT3		EQU	2	; IN PUSH SW BIT 2
PS_SEL		EQU	1	; 001 = SELECTOR
PS_VUP		EQU	2	; 010 = VOLUME UP
PS_VDN		EQU	3	; 011 = VOLUME DOWN
PS_STOP		EQU	4	; 100 = STOP PLAY
PS_PLAY		EQU	5	; 101 = START PLAY
PS_EXIT		EQU	6	; 110 = EXIT MENU
PS_ENT		EQU	7	; 111 = ENTER
; ROTALY ENCODER
RE_PORT		EQU	PORTA	; AvXdC EC12E2420801 ROTALY ENCODER
RE_A			EQU	3	; IN ROTALY ENCODER A LINE
RE_B			EQU	5	; IN ROTALY ENCODER B LINE
; ELECTORIC VOLUME
EV_LAT		EQU	0x21
EV_PORT		EQU	PORTB	; LM1972
EV_LS		EQU	0	; OUT LOAD/SHIFT
EV_CLK		EQU	1	; OUT CLOCK
EV_DIN		EQU	2	; OUT DATA IN
; SELECTOR RELAY
SR_LAT		EQU	0x21
SR_PORT		EQU	PORTB
SR_SEL		EQU	3	; OUT SELECTOR  941H-2C-5D
PW_DPVDD		EQU	4	; OUT VDD Power Relay  941H-2C-5D
PW_MAN		EQU	5	; OUT Main Power Relay  941H-2C-5D
; TUNNER
TU_LAT		EQU	0x22
TU_PORT		EQU	PORTC	; TAE5767
TU_RW		EQU	0	; OUT READ/WRITE
TU_CLK		EQU	1	; OUT CLOCK
TU_DATA		EQU	2	; IN/OUT DATA
; DISPLAY
DP_LAT		EQU	0x22
DP_PORT		EQU	PORTC	; DD-25664BE-4A(SSD1322)
DP_CS		EQU	3	; OUT CS#
DP_CLK		EQU	4	; OUT SCLK
DP_DIN		EQU	5	; OUT SDIN
; HOST CONNECT
HC_LAT		EQU	0x22
HC_PORT		EQU	PORTC	; MAX232
HC_RX		EQU	6	; IN  RX
HC_TX		EQU	7	; OUT TX

; WAIT COUNTERS
WCNT0		EQU	0x23
WCNT1		EQU	0x24
WCNT2		EQU	0x25

; RECIVE BUFFER
RC_STAT		EQU	0x26
RC_INDATA		EQU	0		; PC_STAT bit 0=no data  1=in data
RC_ERR		EQU	1		; PC_STAT bit 0=no error 1=error
RC_DATA		EQU	0x27
RC_RETCNT		EQU	0x28
RC_LEN		EQU	0x29
RC_BUF0		EQU	0x2A
RC_BUF1		EQU	0x2B
RC_BUF2		EQU	0x2C
RC_BUF3		EQU	0x2D
RC_BUF4		EQU	0x2E
RC_BUF5		EQU	0x2F
RC_BUF6		EQU	0x30
RC_BUF7		EQU	0x31
RC_BUF8		EQU	0x32
RC_BUF9		EQU	0x33
RC_BUF10		EQU	0x34
RC_BUF11		EQU	0x35
RC_BUF12		EQU	0x36
RC_BUF13		EQU	0x37
RC_BUF14		EQU	0x38
RC_BUF15		EQU	0x39

; DISPLAY CONTROL
DP_BITCNT		EQU	0x3A
DP_PIXWRK		EQU	0x3B
DP_PIXCNT		EQU	0x3C
DP_PIX4G		EQU	0x3D
DP_WTMP		EQU	0x3E
;
; Push Switch
PS_SNS		EQU	0x3F
PS_CODE		EQU	0x40
PS_TIM1		EQU	0x41
PS_TIM2		EQU	0x42
;
; Rotaly Encoder
RE_SNSA		EQU	0x43
RE_SNSB		EQU	0x44
RE_LAT		EQU	0x45
RE_VAL		EQU	0x46
RE_TIM1		EQU	0x47
RE_TIM2		EQU	0x48
RE_DIR		EQU	0x49
;
; Volume command work
EV_DATA		EQU	0x4A
EV_BITCNT		EQU	0x4B
;
; Tunner command work
TU_BITSFT		EQU	0x4C
TU_BITCNT		EQU	0x4D
;
; Display command work

WTEMP		EQU	44H
STTEMP		EQU	45H
;
; Command (8byte block)
;
; TFnnxxxx	Tunner Frequency n n
; TUxxxxxx	Tunner Scan upper
; TLxxxxxx	Tunner Scan lower
; TRxxxxxx	Tunner Report Status
; VSnnnnnn	Volume Set ch0 ch1 ch2 ch3 ch4 ch5 0x00 <= n <= 0x80
; SSnxxxxx	Select Source n
; DGccrrnn	Display Glay Scale Image cc-rr nn + data
; DBnnxxxx	Display Brightness Set nn
;
; Notify
;
; OK			System Ready
; +			Send Next Block
; TRnnnnn		Tunner Report nn:Frequency, n:Stereo, n:Scan Tunned, n:Scan Limit
; PDn		Push Switch n down
; PUn		Push Switch n up
; RRn		Rotaly Encoder n Right
; RLn		Rotaly Encoder n Left
;

			ORG		0
			GOTO	MAIN
			ORG		4
			GOTO	INTR1
INTR1
			MOVWF   WTEMP           ;WX^Ҕ
			SWAPF   STATUS,W
			MOVWF   STTEMP

			BTFSC	INTCON,TMR0IF
			GOTO	INT_TMR
			BTFSC	INTCON,INTF
			GOTO	INT_RB0
			BTFSC	INTCON,RBIF
			GOTO	INT_RB4
INT_RET
			SWAPF   STTEMP,W        ;WX^A
			MOVWF   STATUS
			SWAPF   WTEMP,F
			SWAPF   WTEMP,W
			RETFIE
INT_TMR
			BCF		INTCON,TMR0IF	;INTF荞݃tOZbg
			GOTO	INT_RET
INT_RB0		BCF		INTCON,INTF
			GOTO	INT_RET
INT_RB4		BCF		INTCON,RBIF
			CLRF	INTCON
			GOTO	INT_RET


OPENIMG
;			MOVF	LG_PTR,W
;			INCF	LG_PTR,F
;			ADDWF	PCL,F
;			RETLW	10
;			RETLW	0FFH
;			;	:
;			RETLW	0H

;
; wait 100 micro second (500cycle/20MHz)
WAIT100
			MOVLW	D'100'		; 1		1	= 1		/ 1
			MOVWF	WCNT0		; 1		1	= 1		/ 2
WAIT_0		NOP					; 1		100	= 100	/ 102
			NOP					; 1		100	= 100	/ 202
			DECFSZ	WCNT0,F		; 1(2)	100	= 101	/ 303
			GOTO	WAIT_0		; 2		100	= 200	/ 503
			RETURN				; 2		1	= 2		/ 505
;
; wait 300 micro second (1500cycle/20MHz)
WAIT300
			MOVLW	D'3'			; 1		1	= 1		/ 1
			MOVWF	WCNT0		; 1		1	= 1		/ 2
WAIT_1		MOVLW	D'100'		; *
			MOVWF	WCNT1		; *
WAIT_2		NOP					; *
			NOP					; *
			DECFSZ	WCNT1,F		; * 505cycle * 3 = 1515 / 1518
			GOTO	WAIT_2		; *
			DECFSZ	WCNT0,F		; 1(2)	3	= 4		/ 1522
			GOTO	WAIT_1		; 2		3	= 6		/ 1528
			RETURN				; 2					/ 1530
;
; wait 1000 micro second (5000cycle/20MHz)
WAIT1000
			MOVLW	D'10'		; 1		1	= 1		/ 1
			MOVWF	WCNT0		; 1		1	= 1		/ 2
WAIT_3		MOVLW	D'100'		; *
			MOVWF	WCNT1		; *
WAIT_4		NOP					; *
			NOP					; *
			DECFSZ	WCNT1,F		; * 505	10	= 5050	/ 5053
			GOTO	WAIT_4		; *
			DECFSZ	WCNT0,F		; 1(2)	10	= 11		/ 5054
			GOTO	WAIT_3		; 2		10	= 20		/ 5074
			RETURN				; 2		1	= 2		/ 5076
;
; Main
MAIN
			CLRF	PORTB
			CLRF	ADCON0		;STOP A/D CONV
			BSF		STATUS,RP0	;Page1
			MOVLW	B'00000111'	;16F873A
			MOVWF	CMCON		;Conparetor off
		;	BCF		INTCON,PEIE	;Interapt off
		;	BSF		INTCON,RBIE	;PortB Interapt on
		;	BSF		INTCON,INTE	;PortB Interapt on
		;	BSF		INTCON,GIE	;PortB Interapt on
			CLRF	INTCON
			MOVLW	07H
			MOVWF	ADCON1		;SET TO ALL DIGITAL
			MOVLW	B'11111111'	;
			MOVWF	TRISB		;
			CLRF	TRISA		;
			MOVLW	B'10000000'	;
			MOVWF	TRISC		;
			MOVLW	B'00100100'
			MOVWF	TXSTA
			MOVLW	0x1F
			MOVWF	SPBRG
			BCF		STATUS,RP0	;Page 0
			; USART
			MOVLW	B'10010110'	; 
			MOVWF	RCSTA

			CALL	DP_INIT
;			CALL	LG_SHOW


			MOVLW	'>'
			CALL	TX
MAIN_LOOP
			CALL	PS_SCAN
			CALL	RE_SCAN
			CALL	RC_LINE
			MOVF	RC_LEN,W
			BTFSC	STATUS,Z
			GOTO	MAIN_LOOP
ML_0
			MOVLW	'P'
			SUBWF	RC_BUF0,W
			BTFSS	STATUS,Z
			GOTO	ML_1
			GOTO	C_DSPPIX
ML_1
			MOVLW	'C'
			SUBWF	RC_BUF0,W
			BTFSS	STATUS,Z
			GOTO	ML_2
			GOTO	C_DSPCLEAR
ML_2
			MOVLW	'B'
			SUBWF	RC_BUF0,W
			BTFSS	STATUS,Z
			GOTO	ML_3
			GOTO	C_DSPBRIGHT
ML_3
			MOVLW	'O'
			SUBWF	RC_BUF0,W
			BTFSS	STATUS,Z
			GOTO	ML_4
			GOTO	C_DSPPOWER
ML_4
			MOVLW	'F'
			SUBWF	RC_BUF0,W
			BTFSS	STATUS,Z
			GOTO	ML_5
			GOTO	C_TUNEFRQ
ML_5
			MOVLW	'V'
			SUBWF	RC_BUF0,W
			BTFSS	STATUS,Z
			GOTO	MAIN_CMERR
			GOTO	C_VOLUME
MAIN_CMERR
			MOVLW	'?'
			CALL	TX
			GOTO	MAIN_LOOP
MAIN_PMERR
			MOVLW	'?'
			CALL	TX
			GOTO	MAIN_LOOP

MAIN_OK		MOVLW	'>'
			CALL	TX
			GOTO	MAIN_LOOP
;
; Display Pix 8x8
C_DSPPIX		MOVLW	D'12'
			SUBWF	RC_LEN,W
			BTFSC	STATUS,Z
			GOTO	MAIN_PMERR
			MOVLW	DP_CASET		; column address set
			CALL	DP_SENDCMD
			MOVF	RC_BUF1,W		; x
			CALL	DP_SENDDATA
			MOVLW	1
			ADDWF	RC_BUF1,W		; x+8 pixcel(2 column)
			CALL	DP_SENDDATA
			MOVLW	DP_RASET		; row addres set
			CALL	DP_SENDCMD
			MOVF	RC_BUF2,W		; y
			CALL	DP_SENDDATA
			MOVLW	7
			ADDWF	RC_BUF2,W
			CALL	DP_SENDDATA	; y+7 pixcel
			CALL	DP_RAMWR		; ram write
			MOVF	RC_BUF3,W		; line0
			CALL	DP_SENDPIX
			MOVF	RC_BUF4,W		; line1
			CALL	DP_SENDPIX
			MOVF	RC_BUF5,W		; line2
			CALL	DP_SENDPIX
			MOVF	RC_BUF6,W		; line3
			CALL	DP_SENDPIX
			MOVF	RC_BUF7,W		; line4
			CALL	DP_SENDPIX
			MOVF	RC_BUF8,W		; line5
			CALL	DP_SENDPIX
			MOVF	RC_BUF9,W		; line6
			CALL	DP_SENDPIX
			MOVF	RC_BUF10,W	; line7
			CALL	DP_SENDPIX
			GOTO	MAIN_OK
; 1bit -> 4bit send
DP_SENDPIX	MOVWF	DP_PIXWRK
			MOVLW	4
			MOVWF	DP_PIXCNT
DP_SENDPIX0
			RRF		DP_PIXWRK,F
			BTFSS	STATUS,C
			GOTO	DP_SENDPIX_L
			MOVLW	0xf0
			GOTO	DP_SENDPIX_N
DP_SENDPIX_L	MOVLW	0x00
DP_SENDPIX_N	MOVWF	DP_PIX4G
			RRF		DP_PIXWRK,F
			BTFSS	STATUS,C
			GOTO	DP_SENDPIX_H
			MOVLW	0x0f
			GOTO	DP_SENDPIX_E
DP_SENDPIX_H	MOVLW	0x00
DP_SENDPIX_E	IORWF	DP_PIX4G,F
			CALL	DP_SENDDATA
			DECFSZ	DP_PIXCNT,F
			GOTO	DP_SENDPIX0
			RETURN
;
;  Display Brightness
C_DSPBRIGHT
			GOTO	MAIN_OK
;
;  Display Clear
C_DSPCLEAR
			GOTO	MAIN_OK
;
;  Display VDD Power
C_DSPPOWER
			GOTO	MAIN_OK
;
;  Send Display Data
DP_SEND		MOVLW	8
			MOVWF	DP_BITCNT
DP_SEND_0
			RLF		DP_WTMP,F
			BTFSS	STATUS,C
			GOTO	DP_SEND_1
			BSF		DP_PORT,DP_DIN
			GOTO	DP_SEND_2
DP_SEND_1		BCF		DP_PORT,DP_DIN
DP_SEND_2		CALL	WAIT100
			BSF		DP_PORT,DP_CLK
			CALL	WAIT100
			BCF		DP_PORT,DP_CLK
			DECFSZ	DP_BITCNT,F
			GOTO	DP_SEND_0
			RETURN
			
DP_SENDCMD
			MOVWF	DP_WTMP
			BSF		DP_PORT,DP_CS
			CALL	WAIT100
			BCF		DP_PORT,DP_CLK
			BCF		DP_PORT,DP_DIN
			CALL	WAIT100
			BSF		DP_PORT,DP_CLK
			CALL	WAIT100
			BCF		DP_PORT,DP_CLK
			CALL	DP_SEND
			BCF		DP_PORT,DP_CS
			RETURN

DP_SENDDATA
			MOVWF	DP_WTMP
			BSF		DP_PORT,DP_CS
			CALL	WAIT100
			BCF		DP_PORT,DP_CLK
			BSF		DP_PORT,DP_DIN
			CALL	WAIT100
			BSF		DP_PORT,DP_CLK
			CALL	WAIT100
			BCF		DP_PORT,DP_CLK
			CALL	DP_SEND
			BCF		DP_PORT,DP_CS
			RETURN

DP_INIT		MOVLW	DP_COMLCK	; disable command lock 
			CALL	DP_SENDCMD
			MOVLW	12H
			CALL	DP_SENDDATA

			MOVLW	DP_CASET	; set column address 
			CALL	DP_SENDCMD		; 0-63bytess (0-255bits)
			MOVLW	0
			CALL	DP_SENDDATA
			MOVLW	63
			CALL	DP_SENDDATA

			MOVLW	DP_RASET	; set row address
			CALL	DP_SENDCMD		; 0-63rows
			MOVLW	0
			CALL	DP_SENDDATA
			MOVLW	63
			CALL	DP_SENDDATA
	
			MOVLW	DP_MUXSET	; MUX 63
			CALL	DP_SENDCMD
			MOVLW	63
			CALL	DP_SENDDATA
			
			MOVLW	DP_MAPSET	; VRAM ADDRESS MAP
			CALL	DP_SENDCMD
			MOVLW	0x14
			CALL	DP_SENDDATA
			MOVLW	0x11
			CALL	DP_SENDDATA

			MOVLW	DP_CLKSET	; CLOCK
			CALL	DP_SENDCMD
			MOVLW	0x22
			CALL	DP_SENDDATA
	
			MOVLW	DP_CONTSET	; current contrast
			CALL	DP_SENDCMD
			MOVLW	0x78
			CALL	DP_SENDDATA

			MOVLW	DP_MCONSET	; master contrast
			CALL	DP_SENDCMD
			MOVLW	0x0f
			CALL	DP_SENDDATA

			MOVLW	DP_G4TBRESET	; glay scale table reset
			CALL	DP_SENDCMD

			MOVLW	DP_G4ON		; enable glay scale 
			CALL	DP_SENDCMD

			MOVLW	DP_PLSET	; set pahase length
			CALL	DP_SENDCMD
			MOVLW	0x56
			CALL	DP_SENDDATA

			MOVLW	DP_PCVSET	; set pre-charge voltage
			CALL	DP_SENDCMD
			MOVLW	0x00
			CALL	DP_SENDDATA

			MOVLW	DP_SPPSET	; set second pre charge period
			CALL	DP_SENDCMD
			MOVLW	0x00
			CALL	DP_SENDDATA

			MOVLW	DP_VCOMSET
			CALL	DP_SENDCMD
			MOVLW	0x00
			CALL	DP_SENDDATA

			MOVLW	DP_DMNORM
			CALL	DP_SENDCMD
			
			MOVLW	DP_DSPON
			CALL	DP_SENDCMD
			RETURN
;
; Tunner control
;
C_TUNEFRQ		MOVLW	4
			SUBWF	RC_LEN,W
			BTFSC	STATUS,Z
			GOTO	MAIN_PMERR

			BSF		TU_LAT,TU_RW
			MOVF	TU_LAT,W
			MOVWF	TU_PORT
			CALL	WAIT100

			MOVF	RC_BUF1,W	; byte 1
			CALL	TU_SEND
			MOVF	RC_BUF2,W	; byte 2
			CALL	TU_SEND
			MOVLW	B'00010000'	; byte 3 bit 4 hight side injection
			CALL	TU_SEND
			MOVLW	B'00110010'	; byte 4
			CALL	TU_SEND
			MOVLW	B'10000000'	; byte 5
			CALL	TU_SEND

			BCF		TU_LAT,TU_RW
			BCF		TU_LAT,TU_CLK
			MOVF	TU_LAT,W
			MOVWF	TU_PORT
			GOTO	MAIN_OK
;
; tunner send
TU_SEND
			MOVWF	TU_BITSFT
			MOVLW	8
			MOVWF	TU_BITCNT

TU_SEND_1		RLF		TU_BITSFT,F
			BTFSC	STATUS,C
			GOTO	TU_SEND_2
			BCF		TU_LAT,TU_DATA
			GOTO	TU_SEND_3
TU_SEND_2		BSF		TU_LAT,TU_DATA

TU_SEND_3		MOVFW	TU_LAT
			MOVWF	TU_PORT

			BSF		TU_LAT,TU_CLK
			MOVFW	TU_LAT
			MOVWF	TU_PORT
			CALL	WAIT100

			BCF		TU_LAT,TU_CLK
			MOVFW	TU_LAT
			MOVWF	TU_PORT
			CALL	WAIT100

			DECFSZ	TU_BITCNT,F
			GOTO	TU_SEND_1
			RETURN
;
;
; Volume control
;
C_VOLUME		MOVLW	8
			SUBWF	RC_LEN,W
			BTFSS	STATUS,Z
			GOTO	MAIN_PMERR
			BSF		EV_LAT,EV_LS		; Load/Shift
			BCF		EV_LAT,EV_CLK		; Clock
			BCF		EV_LAT,EV_DIN		; Data In	
			MOVF	EV_LAT,W
			MOVWF	EV_PORT
			CALL	WAIT100

			MOVLW	0x00				; device 0/address 0
			CALL	EV_SEND
			MOVF	RC_BUF1,W
			CALL	EV_SEND
			
			MOVLW	0x01				; device 0/address 1
			CALL	EV_SEND
			MOVF	RC_BUF2,W
			CALL	EV_SEND

			MOVLW	0x00				; device 1/address 0
			CALL	EV_SEND
			MOVF	RC_BUF3,W
			CALL	EV_SEND

			MOVLW	0x01				; device 1/address 1
			CALL	EV_SEND
			MOVF	RC_BUF4,W
			CALL	EV_SEND

			MOVLW	0x00				; device 2/address 0
			CALL	EV_SEND
			MOVF	RC_BUF5,W
			CALL	EV_SEND

			MOVLW	0x01				; device 2/address 1
			CALL	EV_SEND
			MOVF	RC_BUF6,W
			CALL	EV_SEND

			BCF		EV_LAT,EV_LS		; Load/Shift
			BCF		EV_LAT,EV_CLK		; Clock
			BCF		EV_LAT,EV_DIN		; Data In	
			MOVF	EV_LAT,W
			MOVWF	EV_PORT
			CALL	WAIT100

			GOTO	MAIN_OK
;
; Send Volume Data
EV_SEND
			MOVWF	EV_DATA
			MOVLW	8
			MOVWF	EV_BITCNT
EV_SEND_0
			RLF		EV_DATA,F			; 1		1	1
			BTFSS	STATUS,C			; 1(2)	1	2
			GOTO	EV_SEND_1			; 2		2	
			NOP						; 1			1
			BSF		EV_PORT,EV_DIN	; 1			1 *
			GOTO	EV_SEND_2			; 2			2
EV_SEND_1		BCF		EV_PORT,EV_DIN	; 1		1 *
			NOP						; 1		1
			NOP						; 1		1
EV_SEND_2		BSF		EV_PORT,EV_CLK	; 1		1	1
			CALL	WAIT100			; n		n	n
			BCF		EV_PORT,EV_CLK	; 1		1	1
			CALL	WAIT100			; 8		8	8
			DECFSZ	EV_BITCNT,F		; 1(2)	1	1
			GOTO	EV_SEND_0			; 2
			BCF		EV_PORT,EV_DIN
			RETURN					; 2
;
; Scan push switch
PS_SCAN
			MOVFW	PS_PORT		; PORTB -> W
			ANDLW	0x07		; W = W & B'00000111'
			MOVWF	PS_SNS		; SWSNS = W
			BTFSC	STATUS,Z	; IF ZERO
			GOTO	PS_STAT_1
			; KEY DOWN
			SUBWF	PS_CODE,0	; W = SW - W
			BTFSC	STATUS,Z	; IF NOT ZERO
			GOTO	PS_STAT_2	; KEY NOT CHANGE
			; KEY CHANGE
			MOVFW	PS_CODE
			BTFSC	STATUS,Z
			GOTO	PS_STAT_3
			; OTHER KEY DOWN
			CALL	PS_KEYUP
PS_STAT_3
			; FIRST KEY DOWN
			CALL	PS_KEYDOWN
PS_STAT_2
			; RESET KEY DOWN TIMER
			; MOVLW	0xFF
			MOVLW	0x80
			MOVWF	PS_TIM1
			RETURN
PS_STAT_1
			; KEY NOT DOWN
			MOVFW	PS_TIM1
			BTFSC	STATUS,Z
			RETURN
			DECFSZ	PS_TIM1,F
			RETURN
			; TIME OUT
			CALL	PS_KEYUP
			RETURN
PS_KEYDOWN
			MOVFW	PS_SNS
			MOVWF	PS_CODE
			MOVLW	'D'
			CALL	TX
			MOVLW	0x30
			ADDWF	PS_CODE,W
			CALL	TX
			MOVLW	0x0A
			CALL	TX
			RETURN

PS_KEYUP
			MOVLW	'U'
			CALL	TX
			MOVLW	0x30
			ADDWF	PS_CODE,W
			CALL	TX
			MOVLW	0x0A
			CALL	TX
			CLRF	PS_CODE
			RETURN
;
; ROTALY ENCODER SCAN
RE_SCAN
			BTFSS	RE_PORT,RE_A
			GOTO	RE_SCAN_1	
			MOVLW	0x01			; AC = 1
			GOTO	RE_SCAN_2
RE_SCAN_1		MOVLW	0x00			; AC = 0
RE_SCAN_2		MOVWF	RE_SNSA

			BTFSS	RE_PORT,RE_B
			GOTO	RE_SCAN_3	
			MOVLW	0x01			; BC = 1
			GOTO	RE_SCAN_4
RE_SCAN_3		MOVLW	0x00			; BC = 0
RE_SCAN_4		MOVWF	RE_SNSB

			MOVFW	RE_SNSA		; AC̒lςH
			SUBWF	RE_LAT,W		; 
			BTFSS	STATUS,Z		; 
			GOTO	RE_STAT_CHG	; ςRE_STAT_CHG

			MOVF	RE_TIM1,W		; ςȂ
			BTFSS	STATUS,Z		; TIM1JEgȂ
			GOTO	RE_STAT_CNT	; ^C}[JEg
			MOVF	RE_TIM2,W
			BTFSS	STATUS,Z		; TIM2JEgȂ
			GOTO	RE_STAT_CNT	; ^C}[JEg
			RETURN				; Ȃɂ삵ĂȂ

RE_STAT_CHG	MOVFW	RE_SNSA		; ǂݎl
			MOVWF	RE_LAT		; LATɕۑ
			MOVLW	0x01			; ^C}[Zbg
			MOVWF	RE_TIM1		; ̒lŃ`^Oo
			MOVLW	0xFF			; ]ɒǏ]łȂȂ肷邩
			MOVWF	RE_TIM2		; C[v̏vԂŒȂ
			RETURN

RE_STAT_CNT	DECFSZ	RE_TIM2,F		; ^C}[JEg
			RETURN
			MOVLW	0xFF
			MOVWF	RE_TIM2
			DECFSZ	RE_TIM1,F
			RETURN
			CLRF	RE_TIM2		; ^C}[

			MOVF	RE_LAT,W		; OƔr
			SUBWF	RE_VAL,W
			BTFSC	STATUS,Z
			RETURN				; ωĂȂȂ߂

			BTFSC	STATUS,C		; 1 -> 0 Ȃ珕ɂȂ̂END
			GOTO	RE_DIRC_END
RE_DIRC_H		; A 0 -> 1
			MOVF	RE_SNSB,W	
			BTFSS	STATUS,Z
			GOTO	RE_DIRC_HH
RE_DIRC_HL	; B == 0
			MOVLW	'R'			; BC0ȂE]
			GOTO	RE_DIRC_SET
RE_DIRC_HH	; B == 1
			MOVLW	'L'			; BC1Ȃ獶]
RE_DIRC_SET
			MOVWF	RE_DIR
RE_DIRC_END	MOVF	RE_LAT,W		; ̒lۑ
			MOVWF	RE_VAL
			RETURN
;
;	recive command from host
;
; Recive 1 byte
RC_BYTE
			CLRF	RC_STAT
			BTFSS	PIR1,RCIF
			RETURN

			BTFSC	RCSTA,FERR
			GOTO	RC_FERR
			BTFSC	RCSTA,OERR
			GOTO	RC_OERR
			BSF		RC_STAT,RC_INDATA
			MOVF	RCREG,W
			MOVWF	RC_DATA
			RETURN
RC_FERR
			MOVF	RCREG,W
			BSF		RC_STAT,RC_ERR
			RETURN
RC_OERR
			BCF		RCSTA,CREN
			BSF		RCSTA,CREN 
			BSF		RC_STAT,RC_ERR
			RETURN
;
; Recive 1 line
RC_LINE
			CLRF	RC_LEN
			CALL	RC_BYTE
			BTFSC	RC_STAT,RC_ERR
			GOTO	RC_LEERR
			BTFSC	RC_STAT,RC_INDATA
			GOTO	RC_READ
			RETURN
RC_READ		
			MOVLW	RC_BUF0
			MOVWF	FSR
RC_LINE1		MOVF	RC_DATA,W
			MOVWF	INDF
			INCF	FSR,F
			INCF	RC_LEN,F
			SUBLW	0x0d
			BTFSC	STATUS,Z
			GOTO	RC_LINEEND
RC_NEXT
			CALL	RC_BYTE
			BTFSC	RC_STAT,RC_ERR
			GOTO	RC_LEERR
			BTFSS	RC_STAT,RC_INDATA
			GOTO	RC_NEXT
			GOTO	RC_LINE1
RC_LINEEND	RETURN

RC_LEERR		MOVLW	0x64
			MOVWF	RC_RETCNT
RC_LERET		CALL	RC_BYTE
			BTFSC	RC_STAT,RC_INDATA
			GOTO	RC_LERR1
			DECFSZ	RC_RETCNT,F
			GOTO	RC_LERET
			GOTO	RC_LEEND
RC_LERR1		MOVF	RC_DATA,W
			SUBLW	0x0d
			BTFSC	STATUS,Z
			GOTO	RC_LEEND
			GOTO	RC_LEERR
RC_LEEND		MOVLW	'?'
			CALL	TX
			MOVLW	0x0d
			CALL	TX
			CLRF	RC_STAT
			RETURN
;
; send 
TX
			BTFSS	PIR1,TXIF
			GOTO	TX
			MOVWF	TXREG
			RETURN

LG_SHOW
			MOVLW	DP_RASET
			CALL	DP_SENDCMD
			MOVLW	0
			CALL	DP_SENDDATA
			MOVLW	63
			CALL	DP_SENDDATA
			MOVLW	DP_CASET
			CALL	DP_SENDCMD
			MOVLW	0
			CALL	DP_SENDDATA
			MOVLW	63
			CALL	DP_SENDDATA
			MOVLW	DP_RAMWR	; write ram
			CALL	DP_SENDCMD
;			CLRF	LG_PTR
LG_1
			CALL	OPENIMG
;			MOVWF	LG_LEN
;			MOVF	LG_LEN,F
			BTFSC	STATUS,Z
			RETURN
			CALL	OPENIMG
;			MOVWF	LG_DATA
LG_2			CALL	DP_SENDDATA
;			DECFSZ	LG_LEN,F
			GOTO	LG_2
			GOTO	LG_1
			RETURN

			END

