
#ifndef HARDWARE_PROFILE_H
#define HARDWARE_PROFILE_H

    /*******************************************************************/
    /******** USB stack hardware selection options *********************/
    /*******************************************************************/
    //This section is the set of definitions required by the MCHPFSUSB
    //  framework.  These definitions tell the firmware what mode it is
    //  running in, and where it can find the results to some information
    //  that the stack needs.
    //These definitions are required by every application developed with
    //  this revision of the MCHPFSUSB framework.  Please review each
    //  option carefully and determine which options are desired/required
    //  for your application.

    //#define USE_SELF_POWER_SENSE_IO
    #define tris_self_power     1
    #define self_power          1

    //#define USE_USB_BUS_SENSE_IO
    #define tris_usb_bus_sense  TRISCbits.TRISC2    // Input
    #define USB_BUS_SENSE       1 

    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/
    /******** Application specific definitions *************************/
    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/

    #define PROGRAMMABLE_WITH_USB_HID_BOOTLOADER

    /** Board definition ***********************************************/
    //These defintions will tell the main() function which board is
    //  currently selected.  This will allow the application to add
    //  the correct configuration bits as wells use the correct
    //  initialization functions for the board.  These defitions are only
    //  required in the stack provided demos.  They are not required in
    //  final application design.
    #define DEMO_BOARD PIC18F_STARTER_KIT_1
    #define CLOCK_FREQ 48000000
    #define GetSystemClock() CLOCK_FREQ   

    /** LED ************************************************************/
    #define mInitAllLEDs()       
    
    #define mLED_1               
    #define mLED_2               
    #define mLED_3              
    #define mLED_4              
    
    #define mGetLED_1()         1
    #define mGetLED_2()         1
    #define mGetLED_3()         1
    #define mGetLED_4()         1

    #define mLED_1_On()          
    #define mLED_2_On()          
    #define mLED_3_On()         
    #define mLED_4_On()        
    
    #define mLED_1_Off()         
    #define mLED_2_Off()        
    #define mLED_3_Off()        
    #define mLED_4_Off()        
    
    #define mLED_1_Toggle()      
    #define mLED_2_Toggle()      
    #define mLED_3_Toggle()     
    #define mLED_4_Toggle() 
    
    /** SWITCH *********************************************************/
    #define mInitSwitch2()      TRISBbits.TRISB0=1;
    #define mInitSwitch3()      mInitSwitch2();
    #define mInitAllSwitches()  mInitSwitch2();
    #define sw2                 PORTBbits.RB0
    #define sw3                 PORTBbits.RB0

    /** I/O pin definitions ********************************************/
    #define INPUT_PIN 1
    #define OUTPUT_PIN 0

#endif  //HARDWARE_PROFILE_H
