/*
 * avr90usb.h
 *
 * Created: 2012/06/16 18:35:08
 *  Author: tanaka
 */ 


#ifndef AVR90USB_H_
#define AVR90USB_H_

// Used if VBUS_SENSING_IO is defined as "ENABLED"
//#define   VBUS_SENSE_PORT        PORTC   // PORTx
//#define   VBUS_SENSE_PIN         PINC    // PINx
//#define   VBUS_SENSE_DDR         DDRC    // DDRx
//#define   VBUS_SENSE_IO          4       // 0...7
      //! @}

      //! @defgroup STK_526_leds Leds Management
      //! Macros to manage Leds on stk526
      //! @{

//
// PORT MAP
//
// PUSH SWITCH
#define PS_PORT		PORTB	// GENERIC PUSH SWITCH
#define PS_PIN		PINB
#define PS_BIT0		0		// IN PUSH SW BIT 0 / PULL UP
#define PS_BIT1		1		// IN PUSH SW BIT 1 / PULL UP
#define PS_BIT2		2		// IN PUSH SW BIT 2 / PULL UP
#define DDRB_PS		0
#define INIT_PS		((1<<PS_BIT0)|(1<<PS_BIT1)|(1<<PS_BIT2))

#define PS_OFF		7		// 111 = ALL SWITCH OFF
#define PS_KC0		6		// 110 = SELECTOR
#define PS_KC1		5		// 101 = VOLUME UP
#define PS_KC2		4		// 100 = VOLUME DOWN
#define PS_KC3		3		// 011 = STOP PLAY
#define PS_KC4		2		// 010 = START PLAY
#define PS_KC5		1		// 001 = MENU
#define PS_KC6		0		// 000 = ENTER

// ROTALY ENCODER
#define RE_PORT		PORTB	// ALPS ELECTRIC EC12E2420801 ROTALY ENCODER
#define RE_PIN		PINB
#define RE_A		3		// IN ROTALY ENCODER A LINE / PULL UP
#define RE_B		4		// IN ROTALY ENCODER B LINE / PULL UP
#define DDRB_RE		0
#define INIT_RE		((1<<RE_A)|(1<<RE_B))

// ELECTORIC VOLUME
#define EV_PORT		PORTB	// LM1972
#define EV_CLK		5		// OUT CLOCK
#define EV_LS		6		// OUT LOAD/SHIFT
#define EV_DIN		7		// OUT DATA IN
#define DDRB_EV		((1<<EV_LS)|(1<<EV_CLK)|(1<<EV_DIN))
#define INIT_EV		0

// SELECTOR RELAY
#define SR_PORT		PORTC
#define SR_SEL		2		// OUT SELECTOR  941H-2C-5D
#define DDRC_SR		(1<<SR_SEL)
#define INIT_SR		0

// FM TUNNER
#define TU_PORT		PORTC	// TAE5767
#define TU_PIN		PINC
#define TU_RW		5		// OUT READ/WRITE
#define TU_CLK		6		// OUT CLOCK
#define TU_DATA		7		// IN/OUT DATA
#define DDRC_TU		((1<<TU_RW)|(1<<TU_CLK)|(1<<TU_DATA))	// Write
#define DDRC_TUR	((1<<TU_RW)|(1<<TU_CLK))				// Read
#define INIT_TU		0


// DISPLAY
#define SSD_PORT	PORTD	// DD-25664BE-4A(SSD1322)
#define SSD_RES		0		// OUT RESET
#define SSD_CS		1		// OUT CS#
#define SSD_DC		2		// OUT D/C#
#define SSD_CLK		3		// OUT SDIN
#define SSD_DIN		4		// OUT SCLK
#define SSD_POW		5		// OUT DISPLAY POWER
#define DDRD_SSD	((1<<SSD_CS)|(1<<SSD_CLK)|(1<<SSD_DIN)|(1<<SSD_DC)|(1<<SSD_RES)|(1<<SSD_POW))
#define INIT_SSD	((1<<SSD_CS)|(1<<SSD_CLK)|(1<<SSD_DC)|(1<<SSD_RES))

#define portB_init() (DDRB = (DDRB_PS|DDRB_RE|DDRB_EV)/* 0xff (DDRB_PS|DDRB_RE)*/, PORTB = (INIT_PS|INIT_RE|INIT_EV))
#define portC_init() (DDRC = (DDRC_TU|DDRC_SR), PORTC = (INIT_TU|INIT_SR))
#define portD_init() (DDRD = (DDRD_SSD), PORTD = (INIT_SSD))
#define ports_init() (portB_init(), portC_init(), portD_init())

#define  LED_PORT  PORTD
#define  LED_DDR   DDRD
#define  LED_PIN   PIND

#define  LED0_BIT  PIND0
#define  LED1_BIT  PIND1
#define  LED2_BIT  PIND4
#define  LED3_BIT  PIND5


#define  Leds_init()             (LED_DDR  |=  (1<<LED0_BIT)|(1<<LED1_BIT)|(1<<LED2_BIT)|(1<<LED3_BIT), Leds_off())
#define  Leds_on()               (LED_PORT |=  (1<<LED0_BIT)|(1<<LED1_BIT)|(1<<LED2_BIT)|(1<<LED3_BIT))
#define  Leds_off()              (LED_PORT &= ~((1<<LED0_BIT)|(1<<LED1_BIT)|(1<<LED2_BIT)|(1<<LED3_BIT)))
#define  Leds_set_val(c)         (Leds_off(),LED_PORT |= (c<<4)&((1<<LED0_BIT) | (1<<LED1_BIT) | (1<<LED2_BIT) | (1<<LED3_BIT)))
#define  Leds_get_val()          (LED_PORT>>4)
                                
#define  Led0_on()               (LED_PORT |=  (1<<LED0_BIT))
#define  Led1_on()               (LED_PORT |=  (1<<LED1_BIT))
#define  Led2_on()               (LED_PORT |=  (1<<LED2_BIT))
#define  Led3_on()               (LED_PORT |=  (1<<LED3_BIT))
#define  Led0_off()              (LED_PORT &= ~(1<<LED0_BIT))
#define  Led1_off()              (LED_PORT &= ~(1<<LED1_BIT))
#define  Led2_off()              (LED_PORT &= ~(1<<LED2_BIT))
#define  Led3_off()              (LED_PORT &= ~(1<<LED3_BIT))
#define  Led0_toggle()           (LED_PIN  |=  (1<<LED0_BIT))
#define  Led1_toggle()           (LED_PIN  |=  (1<<LED1_BIT))
#define  Led2_toggle()           (LED_PIN  |=  (1<<LED2_BIT))
#define  Led3_toggle()           (LED_PIN  |=  (1<<LED3_BIT))
#define  Is_led0_on()            (LED_PIN  &   (1<<LED0_BIT) ? TRUE : FALSE)
#define  Is_led1_on()            (LED_PIN  &   (1<<LED1_BIT) ? TRUE : FALSE)
#define  Is_led2_on()            (LED_PIN  &   (1<<LED2_BIT) ? TRUE : FALSE)
#define  Is_led3_on()            (LED_PIN  &   (1<<LED3_BIT) ? TRUE : FALSE)
      //! @}

      //! @defgroup STK_5226_joy Joystick Management
      //! Macros to manage Joystick on stk526
      //! @{
#define  Joy_init()              (DDRB &= ~((1<<PINB7)|(1<<PINB6)|(1<<PINB5)|(1<<PINB4)|(1<<PINB0)), PORTB |= ((1<<PINB7)|(1<<PINB6)|(1<<PINB5)|(1<<PINB4)|(1<<PINB0)))
#define  Push_button_init()      Joy_init()
                                
#define  Is_btn_left()           Is_hwb()
#define  Is_btn_middle()         ((PINB & (1<<PINB0)) ?  FALSE : TRUE)
#define  Is_btn_right()          FALSE

#define  Is_joy_down()           ((PINB & (1<<PINB7)) ?  FALSE : TRUE)
#define  Is_joy_right()          ((PINB & (1<<PINB6)) ?  FALSE : TRUE)
#define  Is_joy_up()             ((PINB & (1<<PINB5)) ?  FALSE : TRUE)
#define  Is_joy_left()           ((PINB & (1<<PINB4)) ?  FALSE : TRUE)
                                
#define  Is_btn_not_left()       Is_not_hwb()
#define  Is_btn_not_middle()     ((PINB & (1<<PINB0)) ?  TRUE : FALSE)
#define  Is_btn_not_right()      TRUE

#define  Is_joy_not_down()       ((PINB & (1<<PINB7)) ?  TRUE : FALSE)
#define  Is_joy_not_right()      ((PINB & (1<<PINB6)) ?  TRUE : FALSE)
#define  Is_joy_not_up()         ((PINB & (1<<PINB5)) ?  TRUE : FALSE)
#define  Is_joy_not_left()       ((PINB & (1<<PINB4)) ?  TRUE : FALSE)


//! Enable interrupts for switches (PINB0 and PINB4 to PINB7)
//! - Set up interrupts for switches
//! - clear flag
//! - enable interrupt
#define  Switches_enable_it() {  \
      PCMSK0 |= (1<<PCINT0)|(1<<PCINT4)|(1<<PCINT5)|(1<<PCINT6)|(1<<PCINT7);\
      PCIFR |= (1<<PCIF0);       \
      PCICR |= (1<<PCIE0);}
 
//! Disable interrupts for switches (PINB0 and PINB4 to PINB7)
//! - disable interrupt
//! - clear flag
//! - Clear mask
#define  Switches_disable_it() { \
      PCICR  &= ~(1<<PCIE0);     \
      PCIFR  |= (1<<PCIF0);      \
      PCMSK0 &= ~((1<<PCINT0)|(1<<PCINT4)|(1<<PCINT5)|(1<<PCINT6)|(1<<PCINT7));}
      //! @}


      //! @defgroup STK526_HWB HWB button management
      //! HWB button is connected to PD7 and can also
      //! be used as generic push button
      //! @{
#define  Hwb_button_init()       (DDRD &= ~(1<<PIND7))
#define  Is_hwb()                ((PIND & (1<<PIND7)) ? FALSE : TRUE)
#define  Is_not_hwb()            ((PIND & (1<<PIND7)) ? TRUE : FALSE)
      //! @}


      //! @defgroup STK526 data flash configuration
      //! Macros to init the environnement for DF on STK526 board
      //! @{

// One AT45DB642D
#define DF_8_MB            
#define DF_NB_MEM          1

// PINB0 : SPI Slave Select pin, this pin must be disable (disable input mode) because it is used by joystick
//         Note: the joystick can work fine in Output mode, because the pull-up resistor is activated and the level pin can be read.
// PINB1 : the SCK signal direction is OUTPUT
// PINB2 : the SI signal direction is OUTPUT
// PINB3 : the SO signal direction is INPUT
// PINC2 : the CS signal direction is OUTPUT
#define  Df_init_spi()     (DDRB  &= ~((1<<PINB3)), \
                            DDRB  |=  ((1<<PINB2)|(1<<PINB1)|(1<<PINB0)), \
                            PORTB |=  ((1<<PINB3)|(1<<PINB2)|(1<<PINB1)|(1<<PINB0)),\
                            DDRC  |=  ((1<<PINC2)), \
                            PORTC |=  ((1<<PINC2)) )
#define  Df_select_0()     (PORTC &= ~(1<<PINC2))
#define  Df_desel_all()    (PORTC |=  (1<<PINC2))
      //! @}

//! @}





#endif /* AVR90USB_H_ */