/*
 * bytes.cpp
 *
 *  Created on: 2011/12/23
 *      Author: tanaka
 */
#include <stdlib.h>
#include <memory.h>
#include "../include/elise.h"
#include "platform.h"
#include "memory.h"

#define BUFFER_BLOCKSIZE 16

namespace es {

//static bool initalized = false;
//static LockObject lockObject;

void initializeBytes()
{
//	if( !initalized ) {
//		initLock(lockObject);
//		initalized = true;
//	}
}

void terminateBytes()
{
//	if( initalized ) {
//		releaseLock(lockObject);
//		initalized = false;
//	}
}

static void shAddRef(SHB *ptr)
{
	ptr->ref++;
}

static bool shReleaseRef(SHB *ptr)
{
	ptr->ref--;
	if( ptr->ref == 0 ) {
		if( ptr->bsize ) {
			freeMemory(ptr->_buff);
		}
		return true;
	}
	return false;
}

static bool shResize(SHB *ptr, SIZE size)
{
	SIZE bs = (((size+sizeof(CHAR))/BUFFER_BLOCKSIZE)+1)*BUFFER_BLOCKSIZE;
	if( bs > ptr->bsize ) {
		void * new_buff = resizeMemory(ptr->_buff, bs);
		if( !new_buff ) {
			return false;
		}
		ptr->_buff	= new_buff;
		ptr->bsize	= bs;
	}
	ptr->size	= size;
	BYTE *pc = &ptr->_byte[size];
	SIZE n;
	for( n = 0; n < sizeof(CHAR); n++ ) *pc++ = 0;
	return true;
}

static SHB *shAlloc(SIZE size)
{
	SHB *ptr	 	= static_cast<SHB*>(allocMemory(sizeof(SHB)));
	ptr->ref		= 1;
//	ptr->li.nAccess	= 0;
//	ptr->li.nWait	= 0;
	ptr->_buff		= NULL;
	ptr->bsize		= 0;
	ptr->size		= 0;
	if( size ) {
		if( !shResize(ptr, size) ) {
			return NULL;
		}
	}
	return ptr;
}

bool toIndependent(BYTES *s)
{
	if( s->shptr && s->shptr->ref > 1 ) {
		SHB *nb = shAlloc(s->shptr->size);
		if( !nb ) {
			return false;
		}
		if( !memcpy(nb->_buff, s->shptr->_buff, s->shptr->size) ) {
			shReleaseRef(nb);
			return false;
		}
		shReleaseRef(s->shptr);
		s->shptr = nb;
	}
	return true;
}
/*
static bool isOverlapped(const BYTES * dest, const BYTE * src)
{
	if( dest && src ) {
		const BYTE * destPtr = getBytesReadPtr(dest);
		// Destination buffer and source buffer are the same.
		if( destPtr ) {
			if( destPtr <= src && src < destPtr + dest->shptr->size ) {
				// The destination buffer and the source buffer is overlapped.
				return true;
			}
		}
	}
	return false;
}
*/
BYTES * allocBytes(SIZE bytes)
{
	BYTES *s = static_cast<BYTES *>(allocMemory(sizeof(BYTES *)));
	if( !s ) {
		return NULL;
	}
	SHB *ptr = shAlloc(bytes);
	if( !ptr ) {
		freeMemory(s);
		return NULL;
	}
	s->shptr = ptr;
	return s;
}

void initBytes(BYTES *ptr)
{
	ptr->shptr	= NULL;
}

bool resizeBytes(BYTES *s, SIZE size)
{
	if( s->shptr == NULL ) {
		if( size > 0 ) {
			SHB *sp = shAlloc(size);
			if( sp == NULL ) return false;
			s->shptr = sp;
		}
	} else {
//		lockForWrite(lockObject);
		if( !toIndependent(s) ||
			!shResize(s->shptr, size) ) {
//			unlock(lockObject);
			return false;
		}
//		unlock(lockObject);
	}
	return true;
}

bool extendBytes(BYTES *s, SIZE size)
{
//	lockForWrite(lockObject);
	SIZE nSize = 0;
	if( s->shptr ) nSize = s->shptr->size;
	if( !resizeBytes(s, nSize+size) ) {
//		unlock(lockObject);
		return false;
	}
	if( s->shptr ) s->shptr->size = nSize;
//	unlock(lockObject);
	return true;
}

bool reserveBytes(BYTES *s, SIZE size)
{
	SIZE nSize = 0;
	if( s->shptr ) nSize = s->shptr->size;
	if( s->shptr == NULL ) {
		if( size > 0 ) {
			SHB *sp = shAlloc(size);
			if( sp == NULL ) return false;
			s->shptr = sp;
		}
	} else {
//		lockForWrite(lockObject);
		if( !toIndependent(s) ||
			!shResize(s->shptr, size) ) {
//			unlock(lockObject);
			return false;
		}
//		unlock(lockObject);
	}
	if( s->shptr ) s->shptr->size = nSize;
	return true;
}

void clearBytes(BYTES *s)
{
//	lockForWrite(lockObject);
	if( toIndependent(s) ) {
		if( s && s->shptr ) {
			shReleaseRef(s->shptr);
			s->shptr = NULL;
		}
	}
//	unlock(lockObject);
}

void freeBytes(BYTES *s)
{
	if( s ) {
//		lockForWrite(lockObject);
		if( !toIndependent(s) ) {
//			unlock(lockObject);
			return;
		}
//		unlock(lockObject);
		clearBytes(s);
		freeMemory(s);
	}
}


bool isEmptyBytes(const BYTES *s)
{
//	lockForRead(lockObject);
	bool r = (!s || !s->shptr || s->shptr->size == 0);
//	unlock(lockObject);
	return r;
}

SIZE getBytesSize(const BYTES *s)
{
//	lockForRead(lockObject);
	if( isEmptyBytes(s) ) {
//		unlock(lockObject);
		return 0;
	}
	SIZE r = s->shptr->size;
//	unlock(lockObject);
	return r;
}

SIZE getBytesCapacity(const BYTES *s)
{
//	lockForRead(lockObject);
	if( !s || !s->shptr ) {
//		unlock(lockObject);
		return 0;
	}
	SIZE r = s->shptr->bsize;
//	unlock(lockObject);
	return r;
}

const BYTE * getBytesReadPtr(const BYTES *s)
{
	if( s && s->shptr ) return static_cast<const BYTE *>(s->shptr->_buff);
	return NULL;
}

BYTE * getBytesWritePtr(BYTES *s)
{
//	lockForWrite(lockObject);
	if( !toIndependent(s) ) {
//		unlock(lockObject);
		return NULL;
	}
	BYTE *r = NULL;
	if( s && s->shptr ) r = static_cast<BYTE *>(s->shptr->_buff);
//	unlock(lockObject);
	return r;
}

bool copyBytes(BYTES * dest, const BYTES *src)
{
//	lockForWrite(lockObject);
	if( dest == src ) {
//		unlock(lockObject);
		return true;
	}
	clearBytes(dest);
	if( src && src->shptr ) {
		dest->shptr	= src->shptr;
		shAddRef(dest->shptr);
	}
//	unlock(lockObject);
	return true;
}

bool addByte(BYTES *s, BYTE d)
{
	if( !toIndependent(s) ) {
//		unlock(lockObject);
		return NULL;
	}
	SIZE cs = getBytesSize(s);
	if( !resizeBytes(s,cs+1) ) return false;
	BYTE *r = static_cast<BYTE *>(s->shptr->_buff)+cs;
	*r = d;
	return true;
}

bool addByteSequence(BYTES *s, const BYTE *d, SIZE size)
{
	if( !toIndependent(s) ) {
//		unlock(lockObject);
		return NULL;
	}
	SIZE cs = getBytesSize(s);
	if( !resizeBytes(s,cs+size) ) return false;
	BYTE *r = static_cast<BYTE *>(s->shptr->_buff)+cs;
	return copyMemory(r, d, size);
}

bool setByteSequence(BYTES *s, const BYTE *d, SIZE size)
{
	if( !toIndependent(s) ) {
//		unlock(lockObject);
		return NULL;
	}
	if( !resizeBytes(s,size) ) return false;
	BYTE *r = static_cast<BYTE *>(s->shptr->_buff);
	return copyMemory(r, d, size);
}


bool addBytes(BYTES *s, const BYTES *d)
{
	if( !toIndependent(s) ) {
//		unlock(lockObject);
		return NULL;
	}
	SIZE cs = getBytesSize(s);
	SIZE ds = getBytesSize(d);
	if( !resizeBytes(s,cs+ds) ) return false;
	BYTE *r = static_cast<BYTE *>(s->shptr->_buff)+cs;
	return copyMemory(r, getBytesReadPtr(d), ds);
}

};




