/*
 * bytes.h
 *
 *  Created on: 2011/12/24
 *      Author: tanaka
 */

#ifndef EL_BYTES_H_
#define EL_BYTES_H_

#include "../include/elise.h"
#include "platform.h"
#include "error.h"

namespace es {
class Bytes
{
public:
	Bytes() {
		initBytes(bytesPtr());
	}
	Bytes(const BYTES * d) {
		initBytes(bytesPtr());
		if( !copyBytes(bytesPtr(), d) )
			throw Error();
	}
	Bytes(const BYTES &d) {
		initBytes(bytesPtr());
		if( !copyBytes(bytesPtr(), &d) )
			throw Error();
	}
	Bytes(const BYTE * d, SIZE size) {
		initBytes(bytesPtr());
		if( !setByteSequence(bytesPtr(), d, size) )
			throw Error();
	}
	Bytes(const Bytes &d) {
		initBytes(bytesPtr());
		if( !copyBytes(bytesPtr(), d) )
			throw Error();
	}
	Bytes& operator=(const Bytes &d) {
		if( this != &d ) {
			copy(d);
		}
		return *this;
	}
	virtual ~Bytes() {
		clear();
	}
	void resize(SIZE size) {
		if( !resizeBytes(bytesPtr(), size) )
			throw Error();
	}
	void clear() {
		clearBytes(bytesPtr());
	}
	bool empty() const {
		return isEmptyBytes(bytesPtr());
	}
	SIZE size() const {
		if( !empty() ) {
			return getBytesSize(bytesPtr());
		}
		return 0;
	}
	SIZE capacity() const {
		return getBytesCapacity(bytesPtr());
	}
	const BYTE * ptr() const {
		return getBytesReadPtr(bytesPtr());
	}
	BYTE * ptr() {
		return getBytesWritePtr(bytesPtr());
	}
	const BYTES * bytesPtr() const {
		return &b;
	}
	BYTES * bytesPtr() {
		return &b;
	}
	BYTE at(SIZE pos) const {
		return ptr()[pos];
	}
	void set(SIZE size, const BYTE * set) {
		if( !setByteSequence(bytesPtr(), set, size) )
			throw Error();
	}
	void copy(const BYTES * src) {
		if( !copyBytes(bytesPtr(), src) )
			throw Error();
	}
	void add(BYTE src) {
		if( !addByte(bytesPtr(), src) )
			throw Error();
	}
	void add(WORD src) {
		if( !addByteSequence(bytesPtr(), (const BYTE *)&src, sizeof(WORD)) )
			throw Error();
	}
	void add(DWORD src) {
		if( !addByteSequence(bytesPtr(), (const BYTE *)&src, sizeof(DWORD)) )
			throw Error();
	}
	void add(SIZE size, const BYTE * src) {
		if( !addByteSequence(bytesPtr(), src, size) )
			throw Error();
	}
	void add(const BYTES * src) {
		if( !addBytes(bytesPtr(), src) )
			throw Error();
	}
	operator BYTES * () {
		return bytesPtr();
	}
	operator const BYTES * () const {
		return bytesPtr();
	}
	BYTES*	operator->() {
		return bytesPtr();
	}
	const BYTES* operator->() const {
		return bytesPtr();
	}
	const BYTE & operator[](INT n) const {
		return ptr()[n];
	}
	BYTE &	operator[](INT n) {
		return ptr()[n];
	}
	const BYTE & operator[](SIZE n) const {
		return ptr()[n];
	}
	BYTE &	operator[](SIZE n) {
		return ptr()[n];
	}
	Bytes	operator+(const BYTES * add) const {
		Bytes ret(bytesPtr());
		ret.add(add);
		return ret;
	}
	Bytes	operator+(BYTE add) const {
		Bytes ret(bytesPtr());
		ret.add(add);
		return ret;
	}
	Bytes&	operator+=(const BYTES * d) {
		add(d);
		return *this;
	}
	Bytes&	operator+=(BYTE d) {
		add(d);
		return *this;
	}

protected:
	BYTES b;
};

class BytesArray
{
public:
	BytesArray() {
		nNodes	= 0;
		bNodes	= 0;
		pNodes	= NULL;
	}
	~BytesArray() {
		clear();
	}

	bool add(const BYTES *pBytes) {
		if( nNodes+1 > bNodes ) {
			SIZE bNodesNew = bNodes + 10;
			BYTES *pNodesNew = (BYTES*)resizeMemory(pNodes, sizeof(BYTES*)*bNodesNew);
			if( pNodesNew == NULL ) return false;
			for(SIZE i=bNodes; i<bNodesNew; i++) initBytes(&pNodesNew[i]);
			pNodes	= pNodesNew;
			bNodes	= bNodesNew;
		}
		return copyBytes(&pNodes[nNodes++], pBytes);
	}
	void clear() {
		SIZE i;
		for( i = 0; i < nNodes; i++ ) {
			clearBytes(&pNodes[i]);
		}
		if( pNodes ) freeMemory(pNodes);
		nNodes	= 0;
		bNodes	= 0;
		pNodes	= NULL;
	}
	BYTES *	get(SIZE n) {
		return &pNodes[n];
	}
	SIZE	size() const {
		return nNodes;
	}
	bool empty() const {
		return nNodes==0;
	}
	SIZE		nNodes;
	SIZE		bNodes;
	BYTES *		pNodes;
};

} // es

#endif /* EL_BYTES_H_ */
