/*
 * char_utf8.h
 *
 *  Created on: 2012/01/27
 *      Author: tanaka
 */

#ifndef CHAR_UTF8_H_
#define CHAR_UTF8_H_

#include "string.h"
#include "sstring.h"
#include "platform.h"

namespace es {

SIZE getTrailCharSizeUTF8(SCHAR c)
{
	SCHAR m = c & 0xfc;
	if( m == 0x00 ) return 0;
	if( m == 0xc0 ) return 1;
	if( m == 0xe0 ) return 2;
	if( m == 0xf0 ) return 3;
	if( m == 0xf8 ) return 4;
	if( m == 0xfc ) return 5;
	if( m == 0xfe ) return 6;
	return 0;
}

bool convertUTF8(STRING *d, SSTRING *s)
{
	int n = ::MultiByteToWideChar(CP_UTF8, 0, getSStringReadPtr(s), -1, NULL, 0);
	if( n == 0 ) {
		clearString(d);
		return false;
	}
	resizeString(d, n-1);
	::MultiByteToWideChar(CP_UTF8, 0, getSStringReadPtr(s), -1, getStringWritePtr(d), n);
	return true;
}

} // es

#endif /* CHAR_UTF8_H_ */
