/*
 * classManager.h
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#ifndef CLASSMANAGER_H_
#define CLASSMANAGER_H_

#include "../include/elise.h"
#include "platform.h"

namespace es {

class ClassManager : public IClassManager
{
public:
	ClassManager(IContext *ctx);
	virtual ~ClassManager();
	virtual bool		createClass(REF *result,const CLASSINF *pInfo);
	virtual bool		createSpecializedClass(REF *result, const IObject *temlClass, const IObject *spcClass);
	virtual bool		createVectorizedClass(REF *result, const IObject *cls, INT initLength);
	virtual void		releaseClasses();

	virtual const IObject *getGlobalObject() const;
	virtual bool		findClass(REF *result, const IObject *ns, const SYMBOL *symbol) const;
	virtual bool		findProperty(REF *result, const REF *object, const SYMBOL *name) const;
	virtual bool		findPropertyWithRange(REF *result, const REF *object, const SYMBOL *name, const IObject *findStart, const IObject *findEnd) const;
	virtual bool		findAccessor(REF *result, const REF *propRef, bool getAccess) const;
	virtual const ATTR *findAttr(const REF *ref) const;
	virtual bool		normalizeReference(REF *result, const REF *ref) const;
	virtual bool		getSuperClass(REF *result, const REF *cls) const;
	virtual bool		instanceOf(const REF *cls, const REF *object) const;
	virtual bool		instanceOf(const CHAR *path, const REF *object) const;
	virtual bool		inheritsOf(const REF *cls, const REF *subcls) const;
	virtual bool		inheritsOf(const CHAR *path, const REF *subcls) const;
	virtual bool		typeOf(const REF *cls, const REF *object) const;
	virtual bool		typeOf(const CHAR *path, const REF *object) const;
	virtual const CLASSINF *getClassInfo(const IObject *cls) const;
protected:
};

} // es

#endif /* CLASSMANAGER_H_ */
