/*
 * context.cpp
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#include "context.h"

namespace es {
Context::Context(const STRING* model)
{
	typeManager		= NULL;
	objectManager	= NULL;
	classManager	= NULL;
	executeService	= NULL;
	reporter		= NULL;
}

Context::~Context()
{
//	delete reporter;
	delete executeService;
	delete objectManager;
	delete classManager;
	delete typeManager;
}

bool Context::initRuntime(PROC_ADDR *addr)
{
	addr->setError		= setError;
	addr->setRtError	= setRtError;
	addr->setOsError	= setOsError;

	addr->initLock		= initLock;
	addr->releaseLock	= releaseLock;
	addr->lockForRead	= lockForRead;
	addr->lockForWrite	= lockForWrite;
	addr->unlock		= unlock;

	addr->initParallelLock		= initParallelLock;
	addr->releaseParallelLock	= releaseParallelLock;
	addr->parallelLockForRead	= parallelLockForRead;
	addr->parallelLockForWrite	= parallelLockForWrite;
	addr->parallelUnlock	= parallelUnlock;

	addr->allocMemory		= allocMemory;
	addr->resizeMemory		= resizeMemory;
	addr->freeMemory		= freeMemory;

	addr->allocBytes		= allocBytes;
	addr->initBytes			= initBytes;
	addr->resizeBytes		= resizeBytes;
	addr->extendBytes		= extendBytes;
	addr->clearBytes		= clearBytes;
	addr->freeBytes			= freeBytes;
	addr->isEmptyBytes		= isEmptyBytes;
	addr->getBytesSize		= getBytesSize;
	addr->getBytesCapacity	= getBytesCapacity;
	addr->getBytesWritePtr	= getBytesWritePtr;
	addr->getBytesReadPtr	= getBytesReadPtr;
	addr->copyBytes			= copyBytes;

	addr->allocString		= allocString;
	addr->initString		= initString;
	addr->resizeString		= resizeString;
	addr->extendString		= extendString;
	addr->clearString		= clearString;
	addr->freeString		= freeString;
	addr->isEmptyString		= isEmptyString;
	addr->getStringSize		= getStringSize;
	addr->getStringCapacity	= getStringCapacity;
	addr->getStringWritePtr	= getStringWritePtr;
	addr->getStringReadPtr	= getStringReadPtr;
	addr->copyString		= copyString;

	return true;
}

bool Context::configure(const STRING *model)
{
	typeManager = new TypeManager(this);
	objectManager = new ObjectManager(this);
	classManager = new ClassManager(this);
	executeService = new ExecuteService(this);
	return true;
}

void Context::shutdown()
{
	delete this;
}

bool Context::run()
{
	return true;
}

IReporter *	Context::getReporter()
{
	return reporter;
}

IObjectManager * Context::getObjectManager()
{
	return objectManager;
}

IClassManager * Context::getClassManager()
{
	return classManager;
}

IExecuteService * Context::getExecuteService()
{
	return executeService;
}

ITypeManager * Context::getTypeManager()
{
	return typeManager;
}

}
