/*
 * context.h
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#ifndef CONTEXT_H_
#define CONTEXT_H_

#include "../include/elise.h"
#include "platform.h"
#include "typeManager.h"
#include "objectManager.h"
#include "classManager.h"
#include "executeService.h"

namespace es {
class Context : public IContext
{
public:
	virtual bool 	initRuntime(PROC_ADDR *addr);
	virtual bool	configure(const STRING *model);
	virtual void	shutdown();
	virtual bool	run();
	virtual IReporter *	getReporter();
	virtual IObjectManager *getObjectManager();
	virtual IClassManager *getClassManager();
	virtual IExecuteService *getExecuteService();
	virtual ITypeManager *getTypeManager();

	Context(const STRING* model);

protected:
	virtual ~Context();

	IReporter *reporter;
	TypeManager *typeManager;
	ObjectManager *objectManager;
	ClassManager *classManager;
	ExecuteService *executeService;
};

} // es

#endif /* CONTEXT_H_ */
