/*
 * decimal.cpp
 *
 *  Created on: 2012/01/17
 *      Author: tanaka
 */

#include "decimal.h"

namespace es {

DECIMAL	intToDecimal(INT d)
{
	DECIMAL v;
	v.dv = (INT64)d * 10000L;
	return v;
}

DECIMAL	floatToDecimal(FLOAT d)
{
	DECIMAL v;
	v.dv = (INT64)(d * 10000.0);
	return v;
}

DECIMAL	parseDecimal(const CHAR *str)
{
	DECIMAL fx;
	if( !str ) {
		fx.dv = 0;
		return fx;
	}
	while( *str <= ES_T(' ') && *str != 0 ) str++;
	INT64 i = 0;
	INT64 p = 0;
	INT64 s = 1;
	if( *str == ES_T('-') ) {
		s = -1;
		str++;
	}
	while( ES_T('0') <= *str && *str <= ES_T('9') ) {
		i = i * 10 + (*str-ES_T('0'));
		str++;
	}
	if( *str == ES_T('.') ) {
		INT n=0;
		str++;
		while( ES_T('0') <= *str && *str <= ES_T('9') && n < 4) {
			p = p * 10 + (*str-ES_T('0'));
			str++;
			n++;
		}
		switch( n ) {
		case 1:		p *= 1000;	break;
		case 2:		p *= 100;	break;
		case 3:		p *= 10;	break;
		case 4:		p *= 1;		break;
		}
	}
	fx.dv = (i * 10000 + p) * s;
	return fx;
}

INT		decimalToInt(DECIMAL d)
{
	return  (INT)(d.dv / 10000L);
}

FLOAT	decimalToFloat(DECIMAL d)
{
	return  (FLOAT)d.dv / 10000.0;
}

DECIMAL	decimalAdd(DECIMAL d1, DECIMAL d2)
{
	DECIMAL fx;
	fx.dv = d1.dv + d2.dv;
	return fx;
}

DECIMAL	decimalDec(DECIMAL d1, DECIMAL d2)
{
	DECIMAL fx;
	fx.dv = d1.dv - d2.dv;
	return fx;
}

DECIMAL	decimalMul(DECIMAL d1, DECIMAL d2)
{
	DECIMAL fx;
	INT64 i1 = d1.dv / (INT64)10000;
	INT64 i2 = d2.dv / (INT64)10000;
	INT64 p1 = d1.dv % (INT64)10000;
	INT64 p2 = d2.dv % (INT64)10000;
	INT64 a1 = p1 * p2;	// 100000000
	INT64 a2 = i1 * p2;	// 10000
	INT64 a3 = p1 * i2;	// 10000
	INT64 a4 = i1 * i2;	// 1
	fx.dv	= a2+(a1/10000)+a4*10000+a3;
	return fx;
}

DECIMAL	decimalDiv(DECIMAL d1, DECIMAL d2)
{
	DECIMAL fx;
	if( d2.dv == (INT64)0 ) {
		setError(ERROR_ZERODEVIDE);
		fx.dv = 0;
		return fx;
	}
	if( d1.dv == d2.dv ) {
		fx.dv = 10000L;
	} else if( d2.dv == (INT64)10000 ) {
		fx = d1;
	} else if( d2.dv == (INT64)-10000) {
		fx.dv = -d1.dv;
	} else if( d2.dv % (INT64)10000 == 0 ) {
		fx.dv = d1.dv / (d2.dv/(INT64)10000);
	} else if( d1.dv == (d1.dv * (INT64)10000) / (INT64)10000 ) {
		fx.dv = (d1.dv * (INT64)10000) / d2.dv;
	} else {
		INT64 ans=0;
		INT64 r0 = d1.dv;
		INT64 r1 = d2.dv;
		bool s0 = false;
		bool s1 = false;
		if( r0 < (INT64)0 ) {
			s0 = true;
			r0 = -r0;
		}
		if( r1 < (INT64)0 ) {
			s1 = true;
			r1 = -r1;
		}
		while( r0 != 0 ) {
			INT64 b=r1;
			INT64 a=1;
			while(b * 10 < r0) {
				b = b * (INT64)10;
				a = a * (INT64)10;
			}
			if( r0 < b ) break;
			r0  -= b;
			ans += a;
		}
		ans *= 10000;
		INT64 np=1000;
		while( r0 != (INT64)0 && np != 0) {
			r0 *= (INT64)10;
			if( r0 > r1 ) {
				INT64 a = r0 / r1;
				ans += a * np;
				r0  -= a * r1;
			}
			np /= (INT64)10;
		}
		if( (s0 && s1) || (!s0 && !s1) ) {
			fx.dv = ans;
		} else {
			fx.dv = -ans;
		}
	}
	return fx;
}

DECIMAL	decimalMod(DECIMAL d1, DECIMAL d2)
{
	DECIMAL a = decimalDiv(d1,d2);
	DECIMAL i;
	i.dv = (a.dv / (INT64)10000) * (INT64)10000;
	return decimalDec(d1, decimalMul(i,d2));
}

INT	decimalComp(DECIMAL d1, DECIMAL d2)
{
	if( d1.dv == d2.dv ) return 0;
	if( d1.dv > d2.dv )
		return 1;
	else
		return -1;
}


} // es
