/*
 * executeService.cpp
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#include "executeService.h"
#include "variant.h"
#include "lexer.h"
#include "parser.h"
#include "codegen.h"

namespace es {
Scope::Scope(IContext *ctx, REF *base)
{
	initReference(&this->base);
	this->ctx	= ctx;
	if( base )
		copyReference(&this->base, base);
	nRefBufs	= 0;
	nRefCnts	= 0;
	pRef		= NULL;
}

Scope::~Scope()
{
	SIZE i;
	for( i = 0; i < nRefCnts; i++) {
		clearReference(&pRef[i].ref);
		clearSymbol(&pRef[i].sym);
	}
	freeMemory(pRef);
	clearReference(&base);
}

const REF *Scope::getScopeBase() const
{
	return &base;
}

IContext *Scope::getContext() const
{
	return ctx;
}

REF *Scope::find(const SYMBOL *symbol) const
{
	REF b;
	if( base.object ) {

	}
	return NULL;
}

REF *Scope::find(DWORD id) const
{
	return &pRef[id].ref;
}

Stack::Stack(IContext *ctx)
{
	this->ctx	= ctx;
	this->next	= NULL;
	this->scope	= NULL;
	initReference(&this->exp);
	this->line	= 0;
}
const IScope * Stack::getScope() const
{
	return scope;
}

const INT Stack::getLine() const
{
	return line;
}

const IStack * Stack::getNextStack() const
{
	return next;
}

IContext * Stack::getContext() const
{
	return ctx;
}

const REF * Stack::getException() const
{
	return &exp;
}

Stack::~Stack()
{

}

ExecuteService::ExecuteService(IContext *ctx)
{
	this->ctx	= ctx;
	threadBufs	= 0;
	threadCnts	= 0;
	threadInfo	= NULL;
	tm			= ctx->getTypeManager();
}

ExecuteService::~ExecuteService()
{
	if( threadCnts != 0 ) {
		SIZE i;
		for( i = 0; i < threadCnts; i++) {
			clearThreadInfo(&threadInfo[i]);
		}
		delete [] threadInfo;
	}
}

THREADINF* ExecuteService::addThreadInfo()
{
	if( getThreadInfo() != NULL ) {
		setError(ERROR_THREAD);
		return NULL;
	}
	if( threadCnts+1 >= threadBufs ) {
		SIZE nBufs = threadBufs + 4;
		THREADINF *nInfo = (THREADINF *)resizeMemory(threadInfo, sizeof(THREADINF)*nBufs);
		if(!nInfo) return NULL;
		threadInfo = nInfo;
		threadBufs = nBufs;
	}
	threadInfo[threadCnts].tid		= osGetCurrentThreadId();
	threadInfo[threadCnts].stack	= NULL;
	return &threadInfo[threadCnts];
}

THREADINF *	ExecuteService::getThreadInfo()
{
	DWORD tid = osGetCurrentThreadId();
	SIZE i;
	for( i = 0; i < threadCnts; i++) {
		if( threadInfo[i].tid == tid ) {
			return &threadInfo[i];
		}
	}
	return NULL;
}

void ExecuteService::clearThreadInfo(THREADINF *ti)
{
	Stack *stack = ti->stack;
	while( stack ) {
		Stack *next = (Stack *)stack->getNextStack();
		delete stack;
		stack = next;
	}
}

const IStack * ExecuteService::getStack()
{
	THREADINF *ti = ExecuteService::getThreadInfo();
	if( !ti ) {
		setError(ERROR_THREAD);
		return NULL;
	}
	return ti->stack;
}

bool ExecuteService::resolvSymbol(REF *result, const IScope *scope, const CHAR *path)
{

	return true;
}

bool ExecuteService::resolvSymbol(REF *result, const IScope *scope, const SYMBOL *symbol)
{
	return true;
}

bool ExecuteService::opNeg(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	Variant d;
	if( !tm->isPrimitive(v) ) {
		if( !tm->toPrimitive(d, scope, v))
			return false;
		v = d;
	}
	VariantPtr r(result);
	switch(v->vt) {
	case VT_NULL:
		r.clear();
		break;
	case VT_BOOL:
	case VT_CHAR:
	case VT_BYTE:
	case VT_WORD:
	case VT_DWORD:
		if( !tm->toInt(d, scope, v) ) return false;
		r = -d->dInt;
		break;
	case VT_SHORT:
		r	= -v->dShort;
		break;
	case VT_INT:
		r	= -v->dInt;
		break;
	case VT_DECIMAL:
	case VT_FLOAT:
		r	= -v->dFloat;
		break;
	case VT_STRING:
		if( !tm->toFloat(d, scope, v) ) return false;
		r = -d->dFloat;
		break;
	default:
		setError(ERROR_BADTYPE);
		return false;
	}
	return true;
}

bool ExecuteService::op1(VARIANT *result, const IScope *scope, TokenId op, const VARIANT *v)
{
	switch(op) {
	case TID_FPLUS:			copyVariant(result, v);	return true;
	case TID_FMINUS:		return opNeg(result, scope, v);
	case TID_NOT:			return opNot(result, scope, v);
	case TID_BITNOT:		return opBitCPL(result, scope, v);
	case TID_CAST_BOOL:		return tm->toBool(result, scope, v);
	case TID_CAST_CHAR:		return tm->toChar(result, scope, v);
	case TID_CAST_BYTE:		return tm->toByte(result, scope, v);
	case TID_CAST_WORD:		return tm->toWord(result, scope, v);
	case TID_CAST_DWORD:	return tm->toDWord(result, scope, v);
	case TID_CAST_SHORT:	return tm->toShort(result, scope, v);
	case TID_CAST_INT:		return tm->toInt(result, scope, v);
	case TID_CAST_DECIMAL:	return tm->toDecimal(result, scope, v);
	case TID_CAST_FLOAT:	return tm->toFloat(result, scope, v);
	case TID_CAST_BYTES:	return tm->toBytes(result, scope, v);
	case TID_CAST_STRING:	return tm->toString(result, scope, v);
	}
	return false;
}

bool ExecuteService::opNot(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	return true;
}

bool ExecuteService::opRef(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	return true;
}

bool ExecuteService::opLPlus2(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	return true;
}

bool ExecuteService::opLMinus2(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	return true;
}

bool ExecuteService::opRPlus2(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	return true;
}

bool ExecuteService::opRMinus2(VARIANT *result, const IScope *scope, const VARIANT *v)
{
	return true;
}

bool ExecuteService::opAdd(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opSub(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opMul(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opDiv(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opMod(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opBitCPL(VARIANT *result, const IScope *scope, const VARIANT *d)
{
	return true;
}

bool ExecuteService::opBitAND(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opBitOR(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opBitXOR(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opLShift(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opRShift(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opCompare(INT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh)
{
	return true;
}

bool ExecuteService::opReadIndex(VARIANT *result, const IScope *scope, const VARIANT *vh, const VARIANT *ix)
{
	return true;
}

bool ExecuteService::opWriteIndex(VARIANT *result, const IScope *scope, const VARIANT *vh, const VARIANT *ix, const VARIANT *v)
{
	return true;
}

PARSEINF * ExecuteService::parse(const IScope *scope, const IURL *pURL, ISourceReader *src)
{
	Lexer lex(ctx);
	lex.setSource(pURL, src);
	Parser parser(ctx);
//	DWORD st = ::GetTickCount();
	PARSEINF * inf = parser.parse(&lex);
//	DWORD wt = ::GetTickCount() - st; // 140msec
	if( inf == NULL ) return NULL;

	CodeGenerator gen(ctx);
	Bytes code;
	gen.generate(code, NULL, inf);
	return inf;
}

void ExecuteService::releaseParseInfo(PARSEINF *pInf)
{
	Parser::releaseParseInfo(pInf);
}

bool ExecuteService::generate(BYTES *result, const IScope *scope, const PARSEINF *pInf)
{
	return true;
}

bool ExecuteService::compile(BYTES *result, const IScope *scope, IURL *pURL, IStringReader *src)
{
	return true;
}

IParseInfoWalker * ExecuteService::createParseInfWalker(PARSEINF *pInf)
{
	return NULL;
}


bool ExecuteService::evaluate(VARIANT *result, const IScope *scope, const CHAR *script)
{
	return true;
}

bool ExecuteService::execute(VARIANT *result, const IScope *scope, const IExecutable *exec)
{
	return true;
}

bool ExecuteService::import(IURL *pURL)
{
	return true;
}

IScope * ExecuteService::createStack(const IScope *base, void *)
{
	return NULL;
}

bool ExecuteService::enterTryBlock(const IScope *scope)
{
	return true;
}

bool ExecuteService::leaveTryBlock(const IScope *scope)
{
	return true;
}

bool ExecuteService::throwException(const IScope *scope, REF *ex)
{
	return true;
}

bool ExecuteService::throwException(const IScope *scope, ErrorCode code, const CHAR *msg)
{
	return true;
}

bool ExecuteService::getCurrentException(const IScope *scope, REF *ex)
{
	return true;
}

bool ExecuteService::isInsideTryFrame(const IScope *scope)
{
	return true;
}


DWORD ExecuteService::beginThread(ICallback *cb, const IScope *scope, const REF *funcRef, SIZE argc, const VARIANT *argv)
{
	return true;
}

bool ExecuteService::isAlive(DWORD threadId)
{
	return true;
}

bool ExecuteService::wait(VARIANT *result, INT waitTime)
{
	return true;
}

bool ExecuteService::notify(DWORD threadId, VARIANT *notifyData)
{
	return true;
}

bool ExecuteService::callMethod(const VARIANT *v, const IScope *scope, const REF *ref, SIZE argc, const VARIANT *argv)
{
	return false;
}

bool ExecuteService::getProperty(VARIANT *v, const IScope *scope, const REF *ref)
{
	return false;
}

bool ExecuteService::setProperty(const VARIANT *v, const IScope *scope, const REF *ref)
{
	return false;
}

bool ExecuteService::sendEvent(REF *e)
{
	return true;
}

bool ExecuteService::postEvent(REF *e)
{
	return true;
}

} // es


