/*
 * executeService.h
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#ifndef EXECUTESERVICE_H_
#define EXECUTESERVICE_H_


#include "../include/elise.h"
#include "platform.h"

namespace es {

#define MAGICCODE 0x646c6973

typedef struct _SYMBOLREF {
	SYMBOL	sym;
	REF		ref;
} SYMBOLREF;

class Scope : public IScope
{
public:
	Scope(IContext *ctx, REF *base);
	virtual ~Scope();
	virtual IContext *	getContext() const;
	virtual const REF *getScopeBase() const;
	virtual REF *find(const SYMBOL *symbol) const;
	virtual REF *find(DWORD id) const;

protected:
	IContext *	ctx;
	REF		base;
	SIZE	nRefBufs;
	SIZE	nRefCnts;
	SYMBOLREF *pRef;
};

class Stack : public IStack
{
public:
	Stack(IContext *ctx);
	virtual const IScope *	getScope() const;
	virtual const INT		getLine() const;
	virtual const IStack *	getNextStack() const;
	virtual IContext *		getContext() const;
	virtual const REF *		getException() const;
	virtual ~Stack();

protected:
	IContext *	ctx;
	Stack *		next;
	Scope *		scope;
	REF			exp;
	INT			line;
};

typedef struct _THREADINF {
	DWORD		tid;
	Stack *		stack;
} THREADINF;

enum PathDefCode {
	PDC_PATH	= 1,	// byte:PC_PATH, word:length, word:symbolId,... x length
	PDC_TSCLS	= 2,	// byte:PC_TSCLS, word:templateResultId, word:typeResultId
	PDC_VECT	= 3,	// byte:PC_VECT, word:typeResultId, dword:num
};

typedef struct _PATH_DEF {
	WORD	size;	// size of pdc array
	BYTE	pdc[1];	//PathdefCode
} PATH_DEF;

typedef struct _CDEF {
	WORD		name;		// interface name by symbol id
	INT			line;		// source line
	WORD		acm;		// AccessModifier
	WORD		attrType;	// AttrType
} CDEF;

typedef struct _CDEF_CLASS {
	CDEF		cdef;
	INT			attrs;		// properties count
	WORD		addr[1];	// interface attributes address by PATH_DEF
} CDEF_CLASS;

typedef struct _CDEF_PROPERTY {
	CDEF		cdef;
	WORD		addr;		// class address by PATH_DEF
	WORD		initVT;		// VariantType
	union {
		bool		dBool;
		CHAR		dChar;
		BYTE		dByte;
		WORD		dWord;
		DWORD		dDword;
		SHORT		dShort;
		INT			dInt;
		DECIMAL		dDecimal;
		FLOAT		dFloat;
		WORD		dBytes;		/* cdata offset	*/
		WORD		dString;	/* cdata offset	*/
	} initValue;
} CDEF_PROPERTY;

typedef struct _CDEF_METHOD {
	CDEF		cdef;
	WORD		hasResult;	//
	SHORT		minArgs;
	SHORT		maxArgs;
	DWORD		procAddr;
} CDEF_METHOD;

enum EffectiveMode {
	EM_NA		= 0x00,
	
	EM_MASK		= 0xf0,
	EM_REG		= 0x10,
	EM_OFFSET	= 0x20,
	EM_IMD		= 0x30,
	EM_IGNR		= 0xf0,

	EM_R0		= EM_REG | 0x00,	// Registor
	EM_R1		= EM_REG | 0x01,	// Registor
	EM_R2		= EM_REG | 0x02,	// Registor
	EM_R3		= EM_REG | 0x03,	// Registor
	EM_ST		= EM_REG | 0x08,	// Status Registor 
	EM_RX		= EM_REG | 0x09,	// This pointer
	EM_FP		= EM_REG | 0x0a,	// Frame pointer
	EM_SP		= EM_REG | 0x0b,	// Stack Pointer
	EM_PC		= EM_REG | 0x0c,	// Program counter
	EM_EX		= EM_REG | 0x0d,	// Exception pointer

	EM_OR0		= EM_OFFSET | 0x00,	// Registor
	EM_OR1		= EM_OFFSET | 0x01,	// Registor
	EM_OR2		= EM_OFFSET | 0x02,	// Registor
	EM_OR3		= EM_OFFSET | 0x03,	// Registor
	EM_OFP		= EM_OFFSET | 0x0a,	// Frame pointer
	EM_OSP		= EM_OFFSET | 0x0b,	// Stack Pointer

	EM_NULL		= EM_IMD | 0x00,	// VT_NULL
	EM_BOOL		= EM_IMD | 0x01,	// VT_BOOL
	EM_CHAR		= EM_IMD | 0x02,	// VT_CHAR
	EM_BYTE		= EM_IMD | 0x03,	// VT_BYTE
	EM_WORD		= EM_IMD | 0x04,	// VT_WORD
	EM_DWORD	= EM_IMD | 0x05,	// VT_DWORD
	EM_SHORT	= EM_IMD | 0x07,	// VT_SHORT
	EM_INT		= EM_IMD | 0x08,	// VT_INT
	EM_DECIMAL	= EM_IMD | 0x0a,	// VT_DECIMAL
	EM_FLOAT	= EM_IMD | 0x0b,	// VT_FLOAT
	EM_BYTES	= EM_IMD | 0x0c,	// VT_BYTES
	EM_STRING	= EM_IMD | 0x0d,	// VT_STRING
};

enum StatusBit {
	// 7 6 5 4 3 2 1 0
	// X N Z E G L S 
	// X eXception
	// N Negative
	// Z Zero
	// E Equal
	// G Greater
	// L Less
	// S Stop
	SBX	= 0x80,	// exception
	SBN	= 0x40, // negative
	SBZ	= 0x20,	// zero
	SBE	= 0x10,	// equal
	SBG	= 0x08,	// greater
	SBL	= 0x04,	// less
	SBS	= 0x02,	// stop
};

typedef struct _ED {
	EffectiveMode	mode;
	union {
		INT			offset;		// EM_OFFSET
		bool		dBool;		// EM_BOOL
		CHAR		dChar;		// EM_CHAR
		BYTE		dByte;		// EM_BYTE
		WORD		dWord;		// EM_WORD
		DWORD		dDword;		// EM_DWORD
		SHORT		dShort;		// EM_SHORT
		INT			dInt;		// EM_INT
		DECIMAL		dDecimal;	// EM_DECIMAL
		FLOAT		dFloat;		// EM_FLOAT
		DWORD		dBytes;		// EM_BYTES
		DWORD		dString;	// EM_STRING
	};
} ED;

enum ICode {
	IC_END		=	0x00,	// program end			: <ic>
	IC_NOP		=	0x01,	// no operation			: <ic>
	IC_STOP		=	0x02,	// system stop			: <ic>

	IC_PUSH		=	0x03,	// push registor		: <ic><ed>
	IC_PUSHI	=	0x04,	// push iterate registor: <ic><ed>
	IC_PULL		=	0x05,	// pull registor		: <ic><ed>
	IC_MOVE		=	0x06,	// move registor		: <ic><ed:from><ed:to>
	IC_MOVEV	=	0x07,	// move value			: <ic><ed:from><ed:to>
	IC_CLR		=	0x08,	// clear registor		: <ic><ed>
	IC_LINK		=	0x09,	// link frame pointer	: <ic><word:size><word:xrefid>
	IC_UNLINK	=	0x0a,	// unlink frame pointer	: <ic>

	IC_NEG		=	0x0b,	// arithmetic negative	: <ic><ed>	-> R0
	IC_ADD		=	0x0c,	// arithmetic add		: <ic><ed><ed>	-> R0
	IC_SUB		=	0x0d,	// arithmetic subtract	: <ic><ed><ed>	-> R0
	IC_MUL		=	0x0e,	// arithmetic multiply	: <ic><ed><ed>	-> R0
	IC_DIV		=	0x0f,	// arithmetic devide	: <ic><ed><ed>	-> R0
	IC_MOD		=	0x10,	// arithmetic modulus	: <ic><ed><ed>	-> R0
	IC_INCL		=	0x11,	// post inc				: <ic><ed><ed>	-> R0
	IC_INCR		=	0x12,	// pre inc				: <ic><ed><ed>	-> R0
	IC_DECL		=	0x13,	// post dec				: <ic><ed><ed>	-> R0
	IC_DECR		=	0x14,	// pre dec				: <ic><ed><ed>	-> R0
	IC_BITCPL	=	0x15,	// bitwise complement	: <ic><ed>	-> R0
	IC_BITAND	=	0x16,	// bitwise and			: <ic><ed><ed>	-> R0
	IC_BITXOR	=	0x17,	// bitwise xor			: <ic><ed><ed>	-> R0
	IC_BITOR	=	0x18,	// bitwise or			: <ic><ed><ed>	-> R0
	IC_BITSL	=	0x19,	// bitwise shift left	: <ic><ed><ed>	-> R0
	IC_BITSR	=	0x1a,	// bitwise shift right	: <ic><ed><ed>	-> R0
	IC_ISOF		=	0x1b,	// instanceof			: <ic><ed:object><ed:class>	-> ST
	IC_TPOF		=	0x1c,	// typeof				: <ic><ed:object><ed:class>	-> ST
	IC_SZOF		=	0x1d,	// sizeof(class)		: <ic><ed:object> R0
	IC_TEST		=	0x1e,	// Logical test			: <ic><ed>	-> ST
	IC_NOT		=	0x1f,	// Logical not			: <ic><ed>	-> ST
	IC_AND		=	0x20,	// Logical complement	: <ic><ed><ed>	-> R0
	IC_OR		=	0x21,	// Logical complement	: <ic><ed><ed>	-> R0
	IC_CMP		=	0x22,	// compare				: <ic><ed><ed>	-> ST
	IC_JMP		=	0x23,	// jump					: <ic><oa>
	IC_JZ		=	0x24,	// jump ST(SBZ) set		: <ic><oa>
	IC_JGT		=	0x25,	// jump ST(SBG) set		: <ic><oa>
	IC_JGE		=	0x26,	// jump ST(SBG,SBE) set	: <ic><oa>
	IC_JEQ		=	0x27,	// jump ST(SBE) set		: <ic><oa>
	IC_JLE		=	0x28,	// jump ST(SBL,SBE) set	: <ic><oa>
	IC_JLT		=	0x29,	// jump ST(SBL) set		: <ic><oa>
	IC_SEL		=	0x30,	// select lookup
	IC_SELI		=	0x31,	// select lookup
	IC_TRY		=	0x32,	//
	IC_THROW	=	0x33,	//
	IC_RET		=	0x34,	// return				: <ic><oa>
	IC_SUPR		=	0x35,	// super(objectpath)
	IC_SUPRC	=	0x36,	// super(objectpath)
	IC_REF		=	0x37,	// reference object		: <ic><cd>
	IC_REFP		=	0x38,	// reference property	: op + dword symbol_index(var base)
	IC_REFC		=	0x39,	// reference class		: op + pkg, sym
	IC_REFX		=	0x3a,	// reference current scope object(this): <ic><ed>
	IC_REFPA	=	0x3b,	// reference parent object :	op
	IC_REFRT	=	0x3c,	// reference root object :	op
	IC_REFRI	=	0x3d,	// reference read index	: op(object, var index)
	IC_REFWI	=	0x3e,	// reference write index	: op(object, var index)
	IC_TLINK	=	0x3f,	// tree link			: <ic><ed><si>
	IC_TUNLINK	=	0x40,	// tree unlink			: <ic><ed>
	IC_SET		=	0x41,	// set value			: <ic><ed><ed>
	IC_CALL		=	0x42,	// call function		: <ic><ed:addr><ed:argc>(argv)
	IC_CALLR	=	0x43,	// call and ret function: <ic><ed:addr><ed:argc>(argv)
	IC_NEW		=	0x44,	// new object			: <ic><ed:cls><ed:argc><arr>(argv) -> R0
	IC_IMPORT	=	0x45,	// import URL			: <ic><ed>
	IC_USE		=	0x45,	// import URL			: <ic><ed>
	IC_EXP		=	0x46,	// throw exception code : <ic><ed>
	IC_CAST		=	0x47,	// op ea vt
	IC_INTF		=	0x48,	// define interface	: <ic><cd>
	IC_PAKG		=	0x49,	// define package	: <ic><cd>
	IC_TMPL		=	0x4a,	// define interface	: <ic><cd>
	IC_CLASS	=	0x4b,	// define class		: <ic><cd>
	IC_TSCLS	=	0x4c,	// define template specialization class	: <ic><ed><ed>
	IC_VSCLS	=	0x4d,	// define vecrot specialization class	: <ic><ed>
	IC_FUNC		=	0x4e,	// define function	: <ic><si><w:min><w:max><addr>
	IC_LINE		=	0x4f,	// source line		: <ic><int:line>
};

class ExecuteService : public IExecuteService {
public:
	ExecuteService(IContext *ctx);
	virtual ~ExecuteService();

	virtual const IStack *getStack();

	virtual bool		resolvSymbol(REF *result, const IScope *scope, const CHAR *path);
	virtual bool		resolvSymbol(REF *result, const IScope *scope, const SYMBOL *symbol);

	virtual bool		op1(VARIANT *result, const IScope *scope, TokenId op, const VARIANT *v);
	virtual bool		opNeg(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opNot(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opRef(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opLPlus2(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opLMinus2(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opRPlus2(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opRMinus2(VARIANT *result, const IScope *scope, const VARIANT *v);
	virtual bool		opAdd(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opSub(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opMul(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opDiv(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opMod(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opBitCPL(VARIANT *result, const IScope *scope, const VARIANT *d);
	virtual bool		opBitAND(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opBitOR(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opBitXOR(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opLShift(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opRShift(VARIANT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opCompare(INT *result, const IScope *scope, const VARIANT *lh, const VARIANT *rh);
	virtual bool		opReadIndex(VARIANT *result, const IScope *scope, const VARIANT *vh, const VARIANT *ix);
	virtual bool		opWriteIndex(VARIANT *result, const IScope *scope, const VARIANT *vh, const VARIANT *ix, const VARIANT *v);

	virtual PARSEINF *	parse(const IScope *scope, const IURL *pURL, ISourceReader *src);
	virtual void		releaseParseInfo(PARSEINF *pInf);
	virtual bool		generate(BYTES *result, const IScope *scope, const PARSEINF *pInf);
	virtual bool		compile(BYTES *result, const IScope *scope, IURL *pURL, IStringReader *src);
	virtual IParseInfoWalker *createParseInfWalker(PARSEINF *pInf);

	virtual bool		evaluate(VARIANT *result, const IScope *scope, const CHAR *script);
	virtual bool		execute(VARIANT *result, const IScope *scope, const IExecutable *exec);
	virtual bool		import(IURL *pURL);

	virtual IScope * 	createStack(const IScope *base, void *);
	virtual bool		enterTryBlock(const IScope *scope);
	virtual bool		leaveTryBlock(const IScope *scope);
	virtual bool		throwException(const IScope *scope, REF *ex);
	virtual bool		throwException(const IScope *scope, ErrorCode code, const CHAR *msg);
	virtual bool		getCurrentException(const IScope *scope, REF *ex);
	virtual bool		isInsideTryFrame(const IScope *scope);

	virtual DWORD		beginThread(ICallback *cb, const IScope *scope, const REF *funcRef, SIZE argc, const VARIANT *argv);
	virtual bool		isAlive(DWORD threadId);
	virtual bool		wait(VARIANT *result, INT waitTime);
	virtual bool		notify(DWORD threadId, VARIANT *notifyData);

	virtual bool		callMethod(const VARIANT *v, const IScope *scope, const REF *ref, SIZE argc, const VARIANT *argv);
	virtual bool		getProperty(VARIANT *v, const IScope *scope, const REF *ref);
	virtual bool		setProperty(const VARIANT *v, const IScope *scope, const REF *ref);
	virtual bool		sendEvent(REF *e);
	virtual bool		postEvent(REF *e);

protected:
	THREADINF *	addThreadInfo();
	THREADINF *	getThreadInfo();
	void		clearThreadInfo(THREADINF *ti);

	IContext *		ctx;
	SIZE			threadBufs;
	SIZE			threadCnts;
	THREADINF *		threadInfo;
	ITypeManager *	tm;
};

} // es

#endif /* EXECUTESERVICE_H_ */
