/*
 * lex.h
 *
 *  Created on: 2012/01/17
 *      Author: tanaka
 */

#ifndef LEX_H_
#define LEX_H_

#include "../include/elise.h"
#include "platform.h"
#include "string.h"
#include "symbol.h"

namespace es {

class SourceChunk {
public:
	enum {
		READ_ERROR = 1,
	};
	SourceChunk();
	~SourceChunk();
	bool	setSource(ISourceReader *reader);
	SCHAR	getChar();
	SCHAR	nextChar();
	const SCHAR *getBufferPtr(SIZE &maxChars);
	bool	movePosition(INT offset);
	SIZE	getPosition();
	bool	savePoint();
	bool	clearPoint();
	bool	rewindPoint();

protected:
	ISourceReader *reader;
	SIZE	readPosition;
	SIZE	filePosition;
	SIZE	ugReadPosition;
	SIZE	ugFilePosition;
	SIZE	chunkSize;
	SSTRING	chunkBuffer;
	SIZE	nSavePosition;
	SIZE	bSavePosition;
	SIZE *	pSavePosition;
};

typedef struct _LEXERSTATE {
	SIZE		position;
	SIZE		line;
	VARIANT		value;
} LEXERSTATE;

typedef struct _PARSE_INFO PARSE_INFO;
struct _PARSE_INFO {
	INT				line;
	INT				position;
	INT				size;
	INT				statementType;
	PARSE_INFO	*	parent;
	PARSE_INFO	*	prev;
	PARSE_INFO	*	next;
	BYTE			code[1];
};

class ParseInfoStack
{
public:
	enum {
		BLOCK_SIZE = 10,
	};
	ParseInfoStack() {
		nNodes	= 0;
		bNodes	= 0;
		pNodes	= NULL;
	}
	~ParseInfoStack() {
		if( pNodes ) freeMemory(pNodes);
	}

	bool push(PARSE_INFO * info) {
		if( nNodes+1 > bNodes ) {
			SIZE bNodesNew = bNodes + BLOCK_SIZE;
			PARSE_INFO ** pNodesNew = (PARSE_INFO **)resizeMemory(pNodes, sizeof(PARSE_INFO *)*bNodesNew);
			if( pNodesNew == NULL ) return false;
			pNodes	= pNodesNew;
			bNodes	= bNodesNew;
		}
		pNodes[nNodes++] = info;
		return true;
	}
	PARSE_INFO * top() {
		if( nNodes == 0 ) return NULL;
		return pNodes[nNodes-1];
	}
	PARSE_INFO * pop() {
		if( nNodes == 0 ) return NULL;
		return pNodes[--nNodes];
	}
	SIZE	size() const {
		return nNodes;
	}
	SIZE	empty() const {
		return nNodes==0;
	}
	SIZE			nNodes;
	SIZE			bNodes;
	PARSE_INFO **	pNodes;
};

class Lexer
{
public:
	Lexer(IContext *ctx);
	~Lexer();
	void		setSource(const IURL *pURL, ISourceReader *src);
	TokenId		getToken();
	bool		getTokenValue(VARIANT &value) const;
	const IURL *getSourceURL() const;
	INT			getCurrentPos() const;
	INT			getCurrentLine() const;
	INT			getTokenStartPos() const;

	void		initState(LEXERSTATE &st);
	void		saveState(LEXERSTATE &st);
	void		restoreState(LEXERSTATE &st);
	void		freeState(LEXERSTATE &st);

	SIZE	getTrailCharSize(SCHAR c);
	bool	convertEncode(STRING *d, SSTRING *s);
	bool	getCharIf(SCHAR next);
	SCHAR	nextChar();
	SCHAR	getChar();

protected:

	void	initializeTokens();
	TokenId	findReserved(const SSTRING *word);
	bool	findResource(const SSTRING *word, VARIANT *v);
	SCHAR	seekWSPC();

	IContext *		ctx;

	SourceChunk		source;
	LEXERSTATE		state;

	const IURL *	url;
	const IURL *	resourceURL;
	String			resource;

protected:
};

} // es

#endif /* LEX_H_ */
