/*
 * lock.cpp
 *
 *  Created on: 2011/12/23
 *      Author: tanaka
 */

#include "../include/elise.h"
#include "platform.h"

namespace es {

void initParallelLock(ParallelLockObject &lock)
{
	osMutexInit(lock.mutex);
	osEventInit(lock.event);
}

void initLock(LockObject &lock)
{
	initParallelLock(lock.object);
	lock.info.nAccess = 0;
	lock.info.nWait	= 0;
}

void releaseParallelLock(ParallelLockObject &lock)
{
	osEventRelease(lock.event);
	osMutexRelease(lock.mutex);
}

void releaseLock(LockObject &lock)
{
	releaseParallelLock(lock.object);
}

bool parallelLockForRead(ParallelLockObject &lock, LockInfo &info, int wait)
{
	DWORD start = osGetTickTime();
	bool firstWait = true;
	while(1) {
		osMutexLock(lock.mutex);
		if( info.nAccess < 0 ) {
			if( firstWait ) {
				info.nWait++;
				firstWait = false;
			}
			osMutexUnlock(lock.mutex);
			WaitStatus r = osEventWait(lock.event, wait);
			if( r == WAIT_TIMEUP ) {
				if( !firstWait ) {
					osMutexLock(lock.mutex);
					info.nWait--;
					osMutexUnlock(lock.mutex);
				}
				return false;
			}
			if( osGetTickTime() - start > (DWORD)wait ) {
				if( !firstWait ) {
					osMutexLock(lock.mutex);
					info.nWait--;
					osMutexUnlock(lock.mutex);
				}
				return false;
			}
			continue;
		}
		break;
	}
	info.nAccess++;
	if( !firstWait ) info.nWait--;
	osMutexUnlock(lock.mutex);
	return true;
}

bool lockForRead(LockObject &lock, int wait)
{
	return parallelLockForRead(lock.object, lock.info, wait);
}

bool parallelLockForWrite(ParallelLockObject &lock, LockInfo &info, int wait)
{
	DWORD start = osGetTickTime();
	bool firstWait = true;
	while(1) {
		osMutexLock(lock.mutex);
		if( info.nAccess != 0 ) {
			if( firstWait ) {
				info.nWait++;
				firstWait = false;
			}
			osMutexUnlock(lock.mutex);
			WaitStatus r = osEventWait(lock.event, wait);
			if( r == WAIT_TIMEUP ) {
				if( !firstWait ) {
					osMutexLock(lock.mutex);
					info.nWait--;
					osMutexUnlock(lock.mutex);
				}
				return false;
			}
			if( osGetTickTime() - start > (DWORD)wait ) {
				if( !firstWait ) {
					osMutexLock(lock.mutex);
					info.nWait--;
					osMutexUnlock(lock.mutex);
				}
				return false;
			}
			continue;
		}
		break;
	}
	info.nAccess = -1;
	if( !firstWait ) info.nWait--;
	osMutexUnlock(lock.mutex);
	return true;
}

bool lockForWrite(LockObject &lock, int wait)
{
	return parallelLockForWrite(lock.object, lock.info, wait);
}

void parallelUnlock(ParallelLockObject &lock, LockInfo &info)
{
	osMutexLock(lock.mutex);
	if( info.nAccess < 0 )
		info.nAccess = 0;
	else
		info.nAccess--;
	if( info.nWait ) osEventSet(lock.event);
	osMutexUnlock(lock.mutex);
}

void unlock(LockObject &lock)
{
	parallelUnlock(lock.object, lock.info);
}


}
