/*
 * objectManager.h
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#ifndef OBJECTMANAGER_H_
#define OBJECTMANAGER_H_

#include "../include/elise.h"
#include "platform.h"

namespace es {

class ObjectManager : public IObjectManager
{
public:
	ObjectManager(IContext *ctx);
	virtual ~ObjectManager();
	virtual bool		getRootObject(REF *root) const;
	virtual void		manageObject(IObject *object);
	virtual bool		createObject(REF *result, const REF *cls, SIZE argc, const VARIANT *argv);
	virtual bool		createFunction(REF *result, REF *parent, const METHODINF *info);
	virtual bool		cloneObject(REF *result, REF *from);
	virtual bool		findObject(REF *result, const IScope *scope, const SYMBOL *symbol) const;
	virtual void		gc();
	virtual void		dumpLeakObjects(STRING *buff, INT level);
};

} // es


#endif /* OBJECTMANAGER_H_ */
