/*
 * parser.h
 *
 *  Created on: 2012/01/19
 *      Author: tanaka
 */

#ifndef PARSER_H_
#define PARSER_H_

#include "../include/elise.h"
#include "platform.h"
#include "string.h"
#include "symbol.h"
#include "lexer.h"

namespace es {

class ParseStack
{
public:
	enum {
		BLOCK_SIZE = 10,
	};
	ParseStack() {
		nNodes	= 0;
		bNodes	= 0;
		pNodes	= NULL;
	}
	~ParseStack() {
		if( pNodes ) freeMemory(pNodes);
	}

	bool push(PARSEINF* info) {
		if( nNodes+1 > bNodes ) {
			SIZE bNodesNew = bNodes + BLOCK_SIZE;
			PARSEINF** pNodesNew = (PARSEINF**)resizeMemory(pNodes, sizeof(PARSEINF*)*bNodesNew);
			if( pNodesNew == NULL ) return false;
			pNodes	= pNodesNew;
			bNodes	= bNodesNew;
		}
		pNodes[nNodes++] = info;
		return true;
	}
	PARSEINF * top() {
		if( nNodes == 0 ) return NULL;
		return pNodes[nNodes-1];
	}
	PARSEINF * pop() {
		if( nNodes == 0 ) return NULL;
		return pNodes[--nNodes];
	}
	SIZE size() const {
		return nNodes;
	}
	SIZE empty() const {
		return nNodes==0;
	}
	SIZE		nNodes;
	SIZE		bNodes;
	PARSEINF **	pNodes;
};

class ParseInfoWalker : public IParseInfoWalker
{
public:
	ParseInfoWalker(IContext *ctx, PARSEINF *root);
	virtual ~ParseInfoWalker();

	virtual void addRef() const;
	virtual bool releaseRef() const;
	virtual IContext *getContext() const;

	virtual PARSEINF * next();
	virtual PARSEINF * nextStatement();

protected:
	PARSEINF * seekDown();
	PARSEINF * seekUp();
	PARSEINF * seekNext();

	mutable DWORD	refCount;
	IContext *		ctx;
	PARSEINF * 		top;
	PARSEINF * 		cur;
};

class Parser
{
public:
	Parser(IContext *ctx);
	~Parser();
	PARSEINF *	parse(Lexer * pLex);
	IParseInfoWalker *createParseInfoWalker(PARSEINF* info);
	static void	releaseParseInfo(PARSEINF* info);

protected:
	static void	freeParseBlock(PARSEINF *pm);
	PARSEINF *	allocNode(SIZE size);

	PARSEINF *	createParseInfo(StatementType st);
	PARSEINF *	createExpression(ExpressionType pt, TokenId token);
	PARSEINF *	createLiteralExpression(TokenId token);
	PARSEINF *	createSymbolExpression(TokenId token);
	PARSEINF *	createOperator(ExpressionType et, INT prec, AssociateMode ascm, AccessType acc, TokenId tid);
	PARSEINF *	createPathExpression(TokenId token);
	PARSEINF *	createParaExpression(TokenId token);
	PARSEINF *	createTypeExpression(TokenId token);

	bool	stackToken(ExpressionType &prev_type, PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	reduceCheck(PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	reduce(PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	reduce1(PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	reduce2(PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	reduce3(PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	reduceC(PARSEINF * pac, ParseStack &cs, ParseStack &ds);
	bool	isDataExpression(PARSEINF * pc);
	bool	isDataExpression(ExpressionType et);
	bool	isOperatorExpression(PARSEINF * pc);
	bool	isOperatorExpression(ExpressionType et);
	bool	isLiteralExpression(PARSEINF * expr);
	bool	uniqMemberCheck(PARSEINF * pc);
	bool	hasReturnCode(PARSEINF * pc);
	bool	parseACM(TokenId token, AccessModifier &acm);

	PARSEINF *	stageStatement(TokenId token);
	PARSEINF *	stageExpression(TokenId token);
	PARSEINF *	stageLiteralExpression(TokenId token);
	PARSEINF *	stageEvaluateExpression(TokenId token);
	PARSEINF *	stagePathExpression(TokenId token);
	PARSEINF *	stageEOS(TokenId token);
	PARSEINF *	stageImport(TokenId token);
	PARSEINF *	stageUse(TokenId token);
	PARSEINF *	stageBlockStatement(TokenId token);
	PARSEINF *	stageReturn(TokenId token);
	PARSEINF *	stageIf(TokenId token);
	PARSEINF *	stageFor(TokenId token);
	PARSEINF *	stageWhile(TokenId token);
	PARSEINF *	stageDo(TokenId token);
	PARSEINF *	stageSwitch(TokenId token);
	PARSEINF *	stageBreak(TokenId token);
	PARSEINF *	stageContinue(TokenId token);
	PARSEINF *	stageTry(TokenId token);
	PARSEINF *	stageCatch(TokenId token);
	PARSEINF *	stageThrow(TokenId token);
	PARSEINF *	stageFunction(TokenId token);
	PARSEINF *	stagePackage(TokenId token);
	PARSEINF *	stagePackageBlock(TokenId token);
	PARSEINF *	stageClass(TokenId token, AccessModifier acm);
	PARSEINF *	stageClassBlock(TokenId token);
	PARSEINF *	stageInterface(TokenId token, AccessModifier acm);
	PARSEINF *	stageInterfaceBlock(TokenId token);
	PARSEINF *	stageTemplate(TokenId token, AccessModifier acm);
	PARSEINF *	stageExprStatement(TokenId token);
	PARSEINF *	stageObject(TokenId token);
	PARSEINF *	stageMethod(TokenId token, AccessModifier acm);
	PARSEINF *	stageProperty(TokenId token, AccessModifier acm);
	PARSEINF *	stageIMethod(TokenId token, AccessModifier acm);
	PARSEINF *	stageIProperty(TokenId token, AccessModifier acm);
	PARSEINF *	stageClassBlockStatement(TokenId token);
	PARSEINF *	stageInterfaceBlockStatement(TokenId token);
	PARSEINF *	stageReserved(TokenId token);

	IContext *ctx;
	Lexer *	lex;
	BYTE *	parseBlock;
};

} // es

#endif /* PARSER_H_ */
