/*
 * platform.h
 *
 *  Created on: 2011/12/22
 *      Author: tanaka
 */

#ifndef EL_PLATFORM_H_
#define EL_PLATFORM_H_

#include "../include/elise.h"
#ifdef WINDOWS
#	include "windows/platform.h"
#endif
#ifdef LINUX
#	include "linux/platform.h"
#endif

namespace es {
	DWORD 		osGetCurrentThreadId();
	DWORD 		osGetErrorCode();
	DWORD		osGetTickTime();
	void 		osMutexInit(MutexObject &mutex);
	void 		osMutexRelease(MutexObject &mutex);
	void 		osMutexLock(MutexObject &mutex);
	void 		osMutexUnlock(MutexObject &mutex);
	void		osEventInit(EventObject &event);
	void		osEventRelease(EventObject &event);
	WaitStatus	osEventWait(EventObject &event, int wait);
	void		osEventSet(EventObject &event);
}

#endif /* EL_PLATFORM_H_ */
