/*
 * ref.cpp
 *
 *  Created on: 2012/01/11
 *      Author: tanaka
 */
#include <stdlib.h>
#include "../include/elise.h"
#include "platform.h"
#include "ref.h"

namespace es {

void initReference(REF *v)
{
	v->cls		= NULL;
	v->object	= NULL;
	v->prop		= 0;
}

void clearReference(REF * v)
{
	if(v->object) v->object->releaseRef();
	v->cls		= NULL;
	v->object	= NULL;
	v->prop		= 0;
}

bool copyReference(REF * v, const REF * d)
{
	if( v == d ) return true;
	if( !v || !d ) {
		setError(ERROR_PARAMETER);
		return false;
	}
	if( d->object ) d->object->addRef();
	if( v->object ) v->object->releaseRef();
	v->cls		= d->cls;
	v->object	= d->object;
	v->prop		= d->prop;
	return true;
}

bool setReference(REF * v, const IObject *cls, IObject *object, const ATTR * prop)
{
	if( !v ) {
		setError(ERROR_PARAMETER);
		return false;
	}
	if( object ) object->addRef();
	if( v->object ) v->object->releaseRef();
	v->cls		= cls;
	v->object	= object;
	v->prop		= prop;
	return true;
}

} // es



