/*
 * ref.h
 *
 *  Created on: 2012/01/11
 *      Author: tanaka
 */

#ifndef REF_H_
#define REF_H_

#include "../include/elise.h"
#include "platform.h"
#include "error.h"

namespace es {

class Ref {
public:
	Ref() {
		initReference(&r);
	}
	Ref(const Ref &d) {
		initReference(&r);
		copyReference(&r, d);
	}
	Ref(const REF *d) {
		initReference(&r);
		copyReference(&r, d);
	}
	REF *ptr() {
		return &r;
	}
	const REF *ptr() const {
		return &r;
	}
	operator REF*() {
		return ptr();
	}
	operator const REF*() const {
		return ptr();
	}
	REF* operator->() {
		return ptr();
	}
	const REF* operator->() const {
		return ptr();
	}
	Ref &operator=(const REF *d) {
		if( ptr() != d ) {
			clearReference(ptr());
			copyReference(ptr(), d);
		}
		return *this;
	}
	bool operator==(const REF *d) {
		if( ptr() == d ) return true;
		if( ptr()->object == d->object &&
			ptr()->cls == d->cls &&
			ptr()->prop == d->prop ) return true;
		return false;
	}
	void set(const IObject *cls, IObject *obj, const ATTR* prop) {
		setReference(ptr(), cls, obj, prop);
	}
	REF r;
};

} // es

#endif /* REF_H_ */
