/*
 * symbol.cpp
 *
 *  Created on: 2012/01/10
 *      Author: tanaka
 */
#include <stdlib.h>
#include <memory.h>
#include "../include/elise.h"
#include "platform.h"
#include "bytes.h"
#include "string.h"

namespace es {

DWORD	calcSymbolHash(const CHAR * d)
{
	DWORD h=0;
	CHAR s = 1;
	while(*d) {
		CHAR n = *d++;
		DWORD sd = n;
		for( int i = 0; i < s; i++ ) {
			sd = sd << 1;
		}
		h = h + sd;
		s = n & 0x0f;
	}
	return h;
}

SYMBOL * allocSymbol(const CHAR * d)
{
	SIZE n = getCharsLength(d);
	SYMBOL *sp = (SYMBOL*)allocBytes(sizeof(SYMBOLT) + sizeof(CHAR)*n);
	sp->shptr->_symbol->hash	= calcSymbolHash(d);
	sp->shptr->_symbol->len	= n;
	copyChars(sp->shptr->_symbol->symbol, d);
	return sp;
}

void initSymbol(SYMBOL *ptr)
{
	initBytes((BYTES*)ptr);
}

void clearSymbol(SYMBOL * s)
{
	clearBytes((BYTES*)s);
}

void freeSymbol(SYMBOL * s)
{
	freeBytes((BYTES*)s);
}

bool copySymbol(SYMBOL * s, const SYMBOL *d)
{
	return copyBytes((BYTES*)s, (BYTES*)d);
}

bool isEmptySymbol(const SYMBOL * s)
{
	if( !isEmptyBytes((BYTES*)s) ) {
		return s->shptr->_symbol->len == 0;
	}
	return true;
}

SIZE getSymbolSize(const SYMBOL * s)
{
	if( isEmptySymbol(s) ) return 0;
	return s->shptr->_symbol->len;
}

DWORD	getSymbolHash(const SYMBOL * s)
{
	if( isEmptySymbol(s) ) return 0;
	return s->shptr->_symbol->hash;
}

const CHAR *getSymbolPtr(const SYMBOL * s)
{
	if( isEmptySymbol(s) ) return NULL;
	return s->shptr->_symbol->symbol;
}

bool setSymbol(SYMBOL * s, const CHAR * d)
{
	SIZE n = getCharsLength(d);
	return setSymbolLen(s, d, n);
}

bool setSymbolLen(SYMBOL * s, const CHAR * d, SIZE len)
{
	clearBytes((BYTES*)s);
	if( d && len > 0 ) {
		if( !resizeBytes((BYTES*)s, sizeof(SYMBOLT) + sizeof(CHAR)*len) ) {
			return false;
		}
		s->shptr->_symbol->hash	= calcSymbolHash(d);
		s->shptr->_symbol->len		= len;
		copyChars(s->shptr->_symbol->symbol, d);
	}
	return true;
}

bool setSymbolString(SYMBOL * s, const STRING * d)
{
	return setSymbolLen(s, getStringReadPtr(d), getStringSize(d));
}

bool isEqualSymbol(const SYMBOL * s, const CHAR * d)
{
	SIZE len=0;
	if( !d ) {
		len = getCharsLength(d);
	}
	return isEqualSymbolLen(s, d, len);
}

bool isEqualSymbolLen(const SYMBOL * s, const CHAR * d, SIZE len)
{
	if( !d || len == 0 ) {
		if( !s || !s->shptr || !s->shptr->_symbol ) return true;
		return false;
	}
	if( !s || !s->shptr || !s->shptr->_symbol ) {
		return false;
	}
	return isEqualCharsLen(s->shptr->_symbol->symbol, d, len);
}

bool isEqualSymbols(const SYMBOL * s, const SYMBOL * d)
{

	SYMBOLT *s1 = NULL;
	SYMBOLT *s2 = NULL;
	if( s && s->shptr ) s1 = s->shptr->_symbol;
	if( d && d->shptr ) s2 = d->shptr->_symbol;
	if( s1 == s2 ) return true;
	if( !s1 ) {
		if( !s2 ) return true;
		return false;
	}
	if( s1->hash != s2->hash ) return false;
	if( s1->len != s2->len ) return false;
	return isEqualChars(s1->symbol, s2->symbol);
}

} // es
