/*
 * symbol.h
 *
 *  Created on: 2012/01/10
 *      Author: tanaka
 */

#ifndef SYMBOL_H_
#define SYMBOL_H_

#include "../include/elise.h"
#include "error.h"

namespace es {

class Symbol {
public:
	Symbol() {
		s.shptr = NULL;
	}
	Symbol(const CHAR * d) {
		s.shptr = NULL;
		if( !setSymbol(&s, d) )
			throw Error();
	}
	Symbol(const SYMBOL * d) {
		s.shptr = NULL;
		if( !copySymbol(&s, d) )
			throw Error();
	}
	Symbol(const Symbol &d) {
		s.shptr = NULL;
		if( !copySymbol(&s, d) )
			throw Error();
	}
	virtual ~Symbol() {
		clear();
	}

	void	clear() {
		clearSymbol(&s);
	}
	bool	empty() const {
		return isEmptySymbol(&s);
	}
	SIZE	length() const {
		return getSymbolSize(&s);
	}
	const CHAR * ptr() const {
		return getSymbolPtr(&s);
	}
	void	set(const CHAR * set) {
		if( !setSymbol(&s, set) )
			throw Error();
	}
	void	set(const CHAR * set, SIZE len) {
		if( !setSymbolLen(&s, set, len) )
			throw Error();
	}
	void	copy(const SYMBOL * src) {
		if( !copySymbol(&s, src) )
			throw Error();
	}
	bool	equals(const CHAR * cmp) const {
		return isEqualSymbol(&s, cmp);
	}
	bool	equals(const STRING * cmp) const {
		return isEqualSymbol(&s, getStringReadPtr(cmp));
	}
	bool	equals(const SYMBOL * cmp) const {
		return isEqualSymbols(&s, cmp);
	}
	DWORD getHash() const {
		return getSymbolHash(&s);
	}
	operator SYMBOL * () {
		return &s;
	}
	operator const SYMBOL *() const {
		return &s;
	}
	SYMBOL *operator->() {
		return &s;
	}
	const SYMBOL * operator->() const {
		return &s;
	}
	Symbol&	operator=(const Symbol &d) {
		copy(d);
		return *this;
	}
	Symbol&	operator=(const SYMBOL * d) {
		copy(d);
		return *this;
	}
	Symbol&	operator=(const CHAR * d) {
		set(d);
		return *this;
	}

protected:
	SYMBOL s;
};

} // es


#endif /* SYMBOL_H_ */
