/*
 * typeManager.h
 *
 *  Created on: 2012/01/06
 *      Author: tanaka
 */

#ifndef TYPEMANAGER_H_
#define TYPEMANAGER_H_

#include "../include/elise.h"
#include "platform.h"

namespace es {

class TypeManager : public ITypeManager
{
public:
	TypeManager(IContext *ctx);
	virtual ~TypeManager();

	virtual bool	isReference(const VARIANT * v) const;
	virtual bool	isPrimitive(const VARIANT * v) const;
	virtual VariantType	isPrimitiveName(const CHAR *name) const;
	virtual VariantType	isPrimitiveName(const SYMBOL *name) const;

	virtual SIZE		getPrimitiveSize(VariantType vt) const;
	virtual const CHAR *getTypeName(VariantType vt) const;
	virtual bool	normalize(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	changeType(VARIANT * v, const IScope *scope, VariantType type, const VARIANT * t) const;

	virtual bool	toBool(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toChar(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toByte(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toWord(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toDWord(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toShort(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toInt(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toDecimal(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toFloat(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toBytes(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toString(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toPrimitive(VARIANT * v, const IScope *scope, const VARIANT * t) const;
	virtual bool	toPrimitive(VARIANT * v, const IScope *scope, const REF *t ) const;
	virtual bool	toObject(VARIANT * v, const IScope *scope, const VARIANT * t) const;
protected:
	// bool
	bool	charToBool(const IScope *scope, CHAR d) const;
	bool	byteToBool(const IScope *scope, BYTE d) const;
	bool	wordToBool(const IScope *scope, WORD d) const;
	bool	dwordToBool(const IScope *scope, DWORD d) const;
	bool	shortToBool(const IScope *scope, SHORT d) const;
	bool	intToBool(const IScope *scope, INT d) const;
	bool	decimalToBool(const IScope *scope, DECIMAL d) const;
	bool	floatToBool(const IScope *scope, FLOAT d) const;
	bool	bytesToBool(const IScope *scope, const BYTES * d) const;
	bool	stringToBool(const IScope *scope, const STRING * d) const;
	bool	objectToBool(const IScope *scope, const REF * d) const;

	// char
	CHAR	boolToChar(const IScope *scope, bool d) const;
	CHAR	byteToChar(const IScope *scope, BYTE d) const;
	CHAR	wordToChar(const IScope *scope, WORD d) const;
	CHAR	dwordToChar(const IScope *scope, DWORD d) const;
	CHAR	shortToChar(const IScope *scope, SHORT d) const;
	CHAR	intToChar(const IScope *scope, INT d) const;
	CHAR	decimalToChar(const IScope *scope, DECIMAL d) const;
	CHAR	floatToChar(const IScope *scope, FLOAT d) const;
	CHAR	bytesToChar(const IScope *scope, const BYTES * d) const;
	CHAR	stringToChar(const IScope *scope, const STRING * d) const;

	// byte
	BYTE	boolToByte(const IScope *scope, bool d) const;
	BYTE	charToByte(const IScope *scope, CHAR d) const;
	BYTE	wordToByte(const IScope *scope, WORD d) const;
	BYTE	dwordToByte(const IScope *scope, DWORD d) const;
	BYTE	shortToByte(const IScope *scope, SHORT d) const;
	BYTE	intToByte(const IScope *scope, INT d) const;
	BYTE	decimalToByte(const IScope *scope, DECIMAL d) const;
	BYTE	floatToByte(const IScope *scope, FLOAT d) const;
	BYTE	bytesToByte(const IScope *scope, const BYTES * d) const;
	BYTE	stringToByte(const IScope *scope, const STRING * d) const;

	// word
	WORD	boolToWord(const IScope *scope, bool d) const;
	WORD	charToWord(const IScope *scope, CHAR d) const;
	WORD	byteToWord(const IScope *scope, BYTE d) const;
	WORD	dwordToWord(const IScope *scope, DWORD d) const;
	WORD	shortToWord(const IScope *scope, SHORT d) const;
	WORD	intToWord(const IScope *scope, INT d) const;
	WORD	decimalToWord(const IScope *scope, DECIMAL d) const;
	WORD	floatToWord(const IScope *scope, FLOAT d) const;
	WORD	bytesToWord(const IScope *scope, const BYTES * d) const;
	WORD	stringToWord(const IScope *scope, const STRING * d) const;

	// dword
	DWORD	boolToDWord(const IScope *scope, bool d) const;
	DWORD	charToDWord(const IScope *scope, CHAR d) const;
	DWORD	byteToDWord(const IScope *scope, BYTE d) const;
	DWORD	wordToDWord(const IScope *scope, WORD d) const;
	DWORD	shortToDWord(const IScope *scope, SHORT d) const;
	DWORD	intToDWord(const IScope *scope, INT d) const;
	DWORD	decimalToDWord(const IScope *scope, DECIMAL d) const;
	DWORD	floatToDWord(const IScope *scope, FLOAT d) const;
	DWORD	bytesToDWord(const IScope *scope, const BYTES * d) const;
	DWORD	stringToDWord(const IScope *scope, const STRING * d) const;

	// short
	SHORT	boolToShort(const IScope *scope, bool d) const;
	SHORT	charToShort(const IScope *scope, CHAR d) const;
	SHORT	byteToShort(const IScope *scope, BYTE d) const;
	SHORT	wordToShort(const IScope *scope, WORD d) const;
	SHORT	dwordToShort(const IScope *scope, DWORD d) const;
	SHORT	intToShort(const IScope *scope, INT d) const;
	SHORT	decimalToShort(const IScope *scope, DECIMAL d) const;
	SHORT	floatToShort(const IScope *scope, FLOAT d) const;
	SHORT	bytesToShort(const IScope *scope, const BYTES * d) const;
	SHORT	stringToShort(const IScope *scope, const STRING * d) const;

	// int
	INT		boolToInt(const IScope *scope, bool d) const;
	INT		charToInt(const IScope *scope, CHAR d) const;
	INT		byteToInt(const IScope *scope, BYTE d) const;
	INT		wordToInt(const IScope *scope, WORD d) const;
	INT		dwordToInt(const IScope *scope, DWORD d) const;
	INT		shortToInt(const IScope *scope, SHORT d) const;
	INT		decimalToInt(const IScope *scope, DECIMAL d) const;
	INT		floatToInt(const IScope *scope, FLOAT d) const;
	INT		bytesToInt(const IScope *scope, const BYTES * d) const;
	INT		stringToInt(const IScope *scope, const STRING * d) const;

	// decimal
	DECIMAL	boolToDecimal(const IScope *scope, bool d) const;
	DECIMAL	charToDecimal(const IScope *scope, CHAR d) const;
	DECIMAL	byteToDecimal(const IScope *scope, BYTE d) const;
	DECIMAL	wordToDecimal(const IScope *scope, WORD d) const;
	DECIMAL	dwordToDecimal(const IScope *scope, DWORD d) const;
	DECIMAL	shortToDecimal(const IScope *scope, SHORT d) const;
	DECIMAL	intToDecimal(const IScope *scope, INT d) const;
	DECIMAL	floatToDecimal(const IScope *scope, FLOAT d) const;
	DECIMAL	bytesToDecimal(const IScope *scope, const BYTES * d) const;
	DECIMAL	stringToDecimal(const IScope *scope, const STRING * d) const;

	// float
	FLOAT	boolToFloat(const IScope *scope, bool d) const;
	FLOAT	charToFloat(const IScope *scope, CHAR d) const;
	FLOAT	byteToFloat(const IScope *scope, BYTE d) const;
	FLOAT	wordToFloat(const IScope *scope, WORD d) const;
	FLOAT	dwordToFloat(const IScope *scope, DWORD d) const;
	FLOAT	shortToFloat(const IScope *scope, SHORT d) const;
	FLOAT	intToFloat(const IScope *scope, INT d) const;
	FLOAT	decimalToFloat(const IScope *scope, DECIMAL d) const;
	FLOAT	bytesToFloat(const IScope *scope, const BYTES * d) const;
	FLOAT	stringToFloat(const IScope *scope, const STRING * d) const;

	// bytes
	bool	toBytes(SIZE size, const BYTE *d, BYTES * ptr) const;
	bool	boolToBytes(const IScope *scope, bool d, BYTES * ptr) const;
	bool	stringToBytes(const IScope *scope, const STRING * d, BYTES * ptr) const;

	// string
	bool	boolToString(const IScope *scope, bool d, STRING * ptr) const;
	bool	charToString(const IScope *scope, CHAR d, STRING * ptr) const;
	bool	byteToString(const IScope *scope, BYTE d, STRING * ptr) const;
	bool	wordToString(const IScope *scope, WORD d, STRING * ptr) const;
	bool	dwordToString(const IScope *scope, DWORD d, STRING * ptr) const;
	bool	shortToString(const IScope *scope, SHORT d, STRING * ptr) const;
	bool	intToString(const IScope *scope, INT d, STRING * ptr) const;
	bool	decimalToString(const IScope *scope, DECIMAL d, STRING * ptr) const;
	bool	floatToString(const IScope *scope, FLOAT d, STRING * ptr) const;
	bool	bytesToString(const IScope *scope, const BYTES * d, STRING * ptr) const;

	// object accessor
	bool	boolToObject(const IScope *scope, bool d, REF * accr) const;
	bool	charToObject(const IScope *scope, CHAR d, REF * accr) const;
	bool	byteToObject(const IScope *scope, BYTE d, REF * accr) const;
	bool	wordToObject(const IScope *scope, WORD d, REF * accr) const;
	bool	dwordToObject(const IScope *scope, DWORD d, REF * accr) const;
	bool	shortToObject(const IScope *scope, SHORT d, REF * accr) const;
	bool	intToObject(const IScope *scope, INT d, REF * accr) const;
	bool	decimalToObject(const IScope *scope, DECIMAL d, REF * accr) const;
	bool	floatToObject(const IScope *scope, FLOAT d, REF * accr) const;
	bool	bytesToObject(const IScope *scope, const BYTES * d, REF * accr) const;
	bool	stringToObject(const IScope *scope, const STRING * d, REF * accr) const;

	IContext *	ctx;
	IObjectManager *om;
	IClassManager *cm;
	IExecuteService *es;
};

} // es

#endif /* TYPEMANAGER_H_ */
