/*
 * variant.cpp
 *
 *  Created on: 2012/01/10
 *      Author: tanaka
 */

#include <stdlib.h>
#include "../include/elise.h"
#include "platform.h"
#include "variant.h"

namespace es {
void initVariant(VARIANT * v)
{
	v->vt	= VT_NULL;
}

void clearVariant(VARIANT * v)
{
	switch(v->vt) {
	case VT_BYTES:
		clearBytes(&v->dBytes);
		break;
	case VT_STRING:
		clearString(&v->dString);
		break;
	case VT_REF:
		clearReference(&v->dRef);
		break;
	}
	fillMemory((BYTE*)v, 0, sizeof(VARIANT));
	v->vt = VT_NULL;
}

bool copyVariant(VARIANT * v, const VARIANT * d)
{
	if( v == d ) return true;
	clearVariant(v);
	if( d == NULL ) return true;
	switch(d->vt) {
	case VT_NULL:	break;
	case VT_BOOL:	v->dBool	= d->dBool;		break;
	case VT_BYTE:	v->dByte	= d->dByte;		break;
	case VT_WORD:	v->dWord	= d->dWord;		break;
	case VT_DWORD:	v->dDword	= d->dDword;	break;
	case VT_SHORT:	v->dShort	= d->dShort;	break;
	case VT_INT:	v->dInt		= d->dInt;		break;
	case VT_CHAR:	v->dChar	= d->dChar;		break;
	case VT_DECIMAL:v->dDecimal	= d->dDecimal;	break;
	case VT_FLOAT:	v->dFloat	= d->dFloat;	break;
	case VT_BYTES:
		if( !copyBytes(&v->dBytes, &d->dBytes) ) {
			return false;
		}
		break;
	case VT_STRING:
		if( !copyString(&v->dString, &d->dString) ) {
			return false;
		}
		break;
	case VT_REF:
		if( !copyReference(&v->dRef, &d->dRef) ) {
			return false;
		}
		break;
	default:
		return false;
	}
	v->vt	= d->vt;
	return true;
}

bool setVariantBytes(VARIANT * v, const BYTES *d)
{
	clearVariant(v);
	if( !copyBytes(&v->dBytes, d) ) return false;
	v->vt	= VT_BYTES;
	return true;
}

bool setVariantChars(VARIANT * v, const CHAR * d)
{
	clearVariant(v);
	if( !setChars(&v->dString, d) ) {
		return false;
	}
	v->vt	= VT_STRING;
	return true;
}

bool setVariantString(VARIANT * v, const STRING *d)
{
	clearVariant(v);
	if( !copyString(&v->dString, d) ) {
		return false;
	}
	v->vt	= VT_STRING;
	return true;
}

bool setVariantReference(VARIANT * v, const REF *d)
{
	clearVariant(v);
	if( !copyReference(&v->dRef, d) ) {
		return false;
	}
	v->vt	= VT_REF;
	return true;
}

} // es

