/*
 * platform.cpp
 *
 *  Created on: 2011/12/22
 *      Author: tanaka
 */

#ifdef WINDOWS

#include "../platform.h"

namespace es {

DWORD osGetErrorCode()
{
	return ::GetLastError();
}

DWORD osGetTickTime()
{
	return ::GetTickCount();
}

DWORD osGetCurrentThreadId()
{
	return GetCurrentThreadId();
}
void osMutexInit(MutexObject &mutex )
{
	InitializeCriticalSection(&mutex);
}
void osMutexRelease(MutexObject &mutex)
{
	DeleteCriticalSection(&mutex);
}
void osMutexLock(MutexObject &mutex)
{
	EnterCriticalSection(&mutex);
}
void osMutexUnlock(MutexObject &mutex)
{
	LeaveCriticalSection(&mutex);
}

void osEventInit(EventObject &event)
{
	event = ::CreateEvent(NULL,FALSE,FALSE,NULL);
}
void osEventRelease(EventObject &event)
{
	::CloseHandle(event);
}
WaitStatus osEventWait(EventObject &event, int wait)
{
	DWORD r = ::WaitForSingleObject(event, wait);
	switch(r) {
	case WAIT_OBJECT_0:
		return WAIT_OK;
	case WAIT_TIMEOUT:
		return WAIT_TIMEUP;
	}
	return WAIT_ERROR;
}
void osEventSet(EventObject &event)
{
	::SetEvent(event);
}

}

#endif // WINDOWS
