/*
 * buffer.h
 *
 *  Created on: 2012/07/05
 *      Author: yasuoki
 */

#ifndef BUFFER_H_
#define BUFFER_H_

#include "../include/sst_types.h"

namespace SST {

class Buffer {
public:
	Buffer() {}
	virtual ~Buffer() {}
private:
	Buffer(const Buffer &c);
	Buffer &operator=(const Buffer &c);
public:
	virtual bool	add(const char *data, ssize_t size) = 0;
	virtual bool	addfmt(const char *fmt, ...) = 0;
	virtual size_t	size() const = 0;
	virtual size_t	get(char *buff, size_t buffSize) = 0;
	virtual size_t	getLine(char *buff, size_t buffSize) = 0;
	virtual size_t	getAt(char *buff, size_t start, size_t len) = 0;
	virtual const char *getPtr() = 0;
	virtual void	clear() = 0;
	virtual bool	empty() const = 0;
};

class CyclicBuffer : public Buffer{
public:
	CyclicBuffer();
	~CyclicBuffer();
private:
	CyclicBuffer(const CyclicBuffer &c);
	CyclicBuffer &operator=(const CyclicBuffer &c);
public:
	bool	add(const char *data, ssize_t size);
	bool	addfmt(const char *fmt, ...);
	size_t	size() const;
	size_t	get(char *buff, size_t buffSize);
	size_t	getLine(char *buff, size_t buffSize);
	size_t	getAt(char *buff, size_t start, size_t len);
	const char *getPtr();
	void	clear();
	bool	empty() const { return nRead == nWrite; }
#ifdef _DEBUG
	bool	ptrTest(size_t a, size_t r, size_t w);
#endif
protected:
	size_t	getFreeSpace(size_t &nLeft, size_t &nRight) const;
	size_t	getUsingSpace(size_t &nLeft, size_t &nRight) const;

	size_t	nAlloc;
	size_t	nWrite;
	size_t	nRead;
	char *	ptr;
};


class StaticBuffer : public Buffer{
public:
	StaticBuffer();
	~StaticBuffer();
private:
	StaticBuffer(const StaticBuffer &c);
	StaticBuffer &operator=(const StaticBuffer &c);
public:
	bool	add(const char *data, ssize_t size);
	bool	addfmt(const char *fmt, ...);
	size_t	size() const;
	size_t	get(char *buff, size_t buffSize);
	size_t	getLine(char *buff, size_t buffSize);
	size_t	getAt(char *buff, size_t start, size_t len);
	const char *getPtr();
	void	clear();
	bool	empty() const;

	const char *store(const char *data, size_t size);
	const char *storePtr() const;

protected:
	StaticBuffer * next;
	size_t	nAlloc;
	size_t	nUse;
	char *	ptr;
	char *	prevStore;
};
}

#endif /* BUFFER_H_ */
