/*
 * commands.h
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#ifndef COMMANDS_H_
#define COMMANDS_H_

#include "../include/sst_types.h"
#include "queue.h"
#include "pjson.h"
#include <event2/event.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <memory.h>

namespace SST {

class QnEnd : public QueueNode
{
public:
	QnEnd() : QueueNode(QueueEnd) {}
};

class QnAccept : public QueueNode
{
public:
	QnAccept(int fd, sockaddr_in *caddr) : QueueNode(QueueAccept) {
		this->fd	= fd;
		memcpy(&addr, caddr, sizeof(sockaddr_in));
	}
	~QnAccept() {
	}
	int	fd;
	sockaddr_in addr;
};

class QnSessionData : public QueueNode
{
public:
	QnSessionData(Session *con) : QueueNode(QueueSessionData) {
		this->con = con;
	}
	~QnSessionData() {
	}
	Session *con;
};

class QnSessionCommand : public QueueNode
{
public:
	QnSessionCommand(Session *con) : QueueNode(QueueSessionCommand) {
		this->con = con;
	}
	~QnSessionCommand() {
	}
	Session *con;
};

class QnRequest : public QueueNode {
public:
	QnRequest(Session *session, Message *request, void *data) : QueueNode(QueueRequest) {
		this->con	= session;
		this->msg	= request;
		this->data	= data;
	}
	~QnRequest() {
	}

	Session	*	con;
	Message	*	msg;
	void *		data;
};

class QnResponse : public QueueNode {
public:
	QnResponse(Session *session, Message *response, void *data) : QueueNode(QueueRequest) {
		this->con	= session;
		this->msg	= response;
		this->data	= data;
	}
	~QnResponse() {
	}

	Session	*	con;
	Message	*	msg;
	void *		data;
};

}

#endif /* COMMANDS_H_ */
