/*
 * database.h
 *
 *  Created on: 2012/06/08
 *      Author: yasuoki
 */

#ifndef DATABASE_H_
#define DATABASE_H_

#include "../include/sst_types.h"
struct redisContext;
struct redisReply;

namespace SST {

class Database {
public:
	Database();
	virtual ~Database();

	virtual bool	configure(Sentinel *obj, Conf *conf);
	virtual bool	checkAccountName(const char *name);
	virtual bool	connect() = 0;
	virtual void	close() = 0;

	virtual DBError	getUserList(size_t nFrom, RecList *pList) = 0;
	virtual DBError	getGroupList(size_t nFrom, RecList *pList) = 0;
	virtual DBError	addAcocunt(Account *account) = 0;
	virtual DBError	removeAcocunt(const char *id) = 0;
	virtual DBError	getAccountId(const char *name, char *id) = 0;
	virtual DBError	getAccountInfo(const char *id, AccountField f, Account **account) = 0;
	virtual DBError	setAccountStat(const char *id, time_t lastLogin) = 0;
	virtual DBError	getParticipationGroupList(const char *id, size_t nFrom, RecList *pList) = 0;
	virtual DBError	participationGroupList(const char *aid, const char *gid) = 0;

	virtual DBError	getDeviceInfo(const char *id, Device *device) = 0;

	virtual DBError getServiceCount(size_t &n) = 0;
	virtual DBError	getServiceList(size_t nFrom, RecList *pList) = 0;

	virtual DBError getServiceInfo(const char *id, ServiceInfo **info) = 0;
	virtual DBError getServiceStatus(const char *id, ServiceStatus &st) = 0;
	virtual DBError	getServiceGroupList(const char *sid, size_t nFrom, RecList *pList) = 0;
	virtual DBError	getResourceList(const char *sid, size_t nFrom, RecList *pList) = 0;
	virtual DBError getResourceInfo(const char *rid, ResourceInfo **info) = 0;

protected:
	Sentinel *	sentinel;
	char		auth[256];
	char		server[256];
	int			port;
	int			threads;
};

class RedisDB : public Database
{
public:
	RedisDB();
	virtual ~RedisDB();

	virtual bool	connect();
	virtual void	close();

	virtual DBError getUserList(size_t nFrom, RecList *pList);
	virtual DBError	getGroupList(size_t nFrom, RecList *pList);
	virtual DBError	addAcocunt(Account *account);
	virtual DBError	removeAcocunt(const char *id);
	virtual DBError	getAccountId(const char *name, char *id);
	virtual DBError	getAccountInfo(const char *id, AccountField f, Account **account);
	virtual DBError	setAccountStat(const char *id, time_t lastLogin);
	virtual DBError	getParticipationGroupList(const char *id, size_t nFrom, RecList *pList);
	virtual DBError	participationGroupList(const char *aid, const char *gid);

	virtual DBError	getDeviceInfo(const char *id, Device *device);

	virtual DBError getServiceCount(size_t &n);
	virtual DBError	getServiceList(size_t nFrom, RecList *pList);

	virtual DBError getServiceInfo(const char *id, ServiceInfo **info);
	virtual DBError getServiceStatus(const char *id, ServiceStatus &st);
	virtual DBError	getServiceGroupList(const char *sid, size_t nFrom, RecList *pList);

	virtual DBError	getResourceList(const char *sid, size_t nFrom, RecList *pList);
	virtual DBError getResourceInfo(const char *rid, ResourceInfo **info);

protected:
	bool getInt(long long int &v, bool &null, const char *msg, const char *fmt, ...);
	bool getStr(redisReply **rep, bool &null, const char *msg, const char *fmt, ...);

	redisContext *conn;
};

}

#endif /* DATABASE_H_ */
